/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.captcha.google;

import java.awt.image.BufferedImage;
import spring.turbo.module.captcha.Captcha;
import spring.turbo.module.captcha.CaptchaService;
import spring.turbo.module.captcha.google.background.BackgroundFactory;
import spring.turbo.module.captcha.google.color.ColorFactory;
import spring.turbo.module.captcha.google.filter.FilterFactory;
import spring.turbo.module.captcha.google.font.FontFactory;
import spring.turbo.module.captcha.google.renderer.TextRenderer;
import spring.turbo.module.captcha.google.word.WordFactory;

public abstract class AbstractGoogleCaptchaService
implements CaptchaService {
    protected FontFactory fontFactory;
    protected WordFactory wordFactory;
    protected ColorFactory colorFactory;
    protected BackgroundFactory backgroundFactory;
    protected TextRenderer textRenderer;
    protected FilterFactory filterFactory;
    protected int width;
    protected int height;

    public FontFactory getFontFactory() {
        return this.fontFactory;
    }

    public void setFontFactory(FontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    public WordFactory getWordFactory() {
        return this.wordFactory;
    }

    public void setWordFactory(WordFactory wordFactory) {
        this.wordFactory = wordFactory;
    }

    public ColorFactory getColorFactory() {
        return this.colorFactory;
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    public BackgroundFactory getBackgroundFactory() {
        return this.backgroundFactory;
    }

    public void setBackgroundFactory(BackgroundFactory backgroundFactory) {
        this.backgroundFactory = backgroundFactory;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    @Override
    public Captcha create() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        this.backgroundFactory.fillBackground(bufferedImage);
        String string = this.wordFactory.getNextWord();
        this.textRenderer.draw(string, bufferedImage, this.fontFactory, this.colorFactory);
        BufferedImage bufferedImage2 = this.filterFactory.apply(bufferedImage);
        return new Captcha(string, bufferedImage2);
    }
}

