/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.captcha.google.background;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import spring.turbo.module.captcha.google.background.BackgroundFactory;
import spring.turbo.module.captcha.google.color.ColorFactory;
import spring.turbo.module.captcha.google.color.SingleColorFactory;

public class SingleColorBackgroundFactory
implements BackgroundFactory {
    private ColorFactory colorFactory;

    public SingleColorBackgroundFactory() {
        this.colorFactory = new SingleColorFactory(Color.WHITE);
    }

    public SingleColorBackgroundFactory(Color color) {
        this.colorFactory = new SingleColorFactory(color);
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    @Override
    public void fillBackground(BufferedImage bufferedImage) {
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(this.colorFactory.getColor(0));
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }
}

