/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.captcha.google.filter;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import spring.turbo.module.captcha.google.filter.FilterFactory;

public class CompositeFilterFactory
implements FilterFactory {
    private final List<FilterFactory> filterFactories;

    public CompositeFilterFactory(FilterFactory ... filterFactoryArray) {
        this.filterFactories = Arrays.asList(filterFactoryArray);
    }

    public CompositeFilterFactory(List<FilterFactory> list) {
        this.filterFactories = list;
    }

    public static CompositeFilterFactory of(FilterFactory ... filterFactoryArray) {
        return new CompositeFilterFactory(filterFactoryArray);
    }

    public static CompositeFilterFactory of(List<FilterFactory> list) {
        return new CompositeFilterFactory(list);
    }

    @Override
    public BufferedImage apply(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = bufferedImage;
        for (FilterFactory filterFactory : this.filterFactories) {
            bufferedImage2 = filterFactory.apply(bufferedImage2);
        }
        return bufferedImage2;
    }
}

