/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.captcha.google.filter.lib;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;
import spring.turbo.module.captcha.google.color.ColorFactory;
import spring.turbo.module.captcha.google.color.SingleColorFactory;
import spring.turbo.module.captcha.google.filter.lib.AbstractImageOp;

public class CurvesImageOp
extends AbstractImageOp {
    private float strokeMin;
    private float strokeMax;
    private ColorFactory colorFactory = new SingleColorFactory();

    public float getStrokeMin() {
        return this.strokeMin;
    }

    public void setStrokeMin(float f) {
        this.strokeMin = f;
    }

    public float getStrokeMax() {
        return this.strokeMax;
    }

    public void setStrokeMax(float f) {
        this.strokeMax = f;
    }

    public ColorFactory getColorFactory() {
        return this.colorFactory;
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    private double hermiteSpline(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5 * d5;
        double d7 = d6 * d5;
        double d8 = -d4 - 2.0 * d2 - 3.0 * d + 3.0 * d3;
        double d9 = d4 + d2 + 2.0 * d - 2.0 * d3;
        return d9 * d7 + d8 * d6 + d2 * d5 + d;
    }

    private double catmullRomSpline(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d3 - d) / 2.0;
        double d7 = (d4 - d2) / 2.0;
        return this.hermiteSpline(d2, d6, d3, d7, d5);
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        double d = bufferedImage2.getWidth();
        double d2 = bufferedImage2.getHeight();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Random random = new Random();
        int n3 = 4 + random.nextInt(3);
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        d -= 10.0;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = (int)(5.0 + (double)n2 * d / (double)(n3 - 1));
            nArray2[n2] = (int)(d2 * (random.nextDouble() * 0.5 + 0.2));
        }
        n2 = 6;
        int[] nArray3 = new int[(n3 - 1) * n2];
        int[] nArray4 = new int[(n3 - 1) * n2];
        for (n = 0; n < n3 - 1; ++n) {
            double d3 = n > 0 ? (double)nArray[n - 1] : (double)(2 * nArray[n] - nArray[n + 1]);
            double d4 = nArray[n];
            double d5 = nArray[n + 1];
            double d6 = n + 2 < n3 ? (double)nArray[n + 2] : (double)(2 * nArray[n + 1] - nArray[n]);
            double d7 = n > 0 ? (double)nArray2[n - 1] : (double)(2 * nArray2[n] - nArray2[n + 1]);
            double d8 = nArray2[n];
            double d9 = nArray2[n + 1];
            double d10 = n + 2 < n3 ? (double)nArray2[n + 2] : (double)(2 * nArray2[n + 1] - nArray2[n]);
            for (int i = 0; i < n2; ++i) {
                nArray3[n * n2 + i] = (int)this.catmullRomSpline(d3, d4, d5, d6, 1.0 / (double)n2 * (double)i);
                nArray4[n * n2 + i] = (int)this.catmullRomSpline(d7, d8, d9, d10, 1.0 / (double)n2 * (double)i);
            }
        }
        for (n = 0; n < nArray3.length - 1; ++n) {
            graphics2D.setColor(this.colorFactory.getColor(n));
            graphics2D.setStroke(new BasicStroke(2.0f + 2.0f * random.nextFloat()));
            graphics2D.drawLine(nArray3[n], nArray4[n], nArray3[n + 1], nArray4[n + 1]);
        }
        return bufferedImage;
    }
}

