/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.captcha.verysimple;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import spring.turbo.module.captcha.Captcha;
import spring.turbo.module.captcha.CaptchaService;

public class SimpleCaptchaService
implements CaptchaService {
    private static final Random RANDOM = new Random();
    private int length = 6;
    private int width = 100;
    private int height = 18;
    private String characters = "absdegkmnopwxABSDEGKMNOPWX23456789";
    private String font = "Times New Roman";

    @Override
    public Captcha create() {
        int n;
        int n2;
        int n3;
        int n4;
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(this.getRandomColor(200, 250));
        graphics.fillRect(1, 1, this.width - 1, this.height - 1);
        graphics.setColor(new Color(102, 102, 102));
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        graphics.setFont(new Font(this.font, 0, 17));
        graphics.setColor(this.getRandomColor(160, 200));
        for (n4 = 0; n4 < 155; ++n4) {
            n3 = RANDOM.nextInt(this.width - 1);
            int c = RANDOM.nextInt(this.height - 1);
            n2 = RANDOM.nextInt(6) + 1;
            n = RANDOM.nextInt(12) + 1;
            graphics.drawLine(n3, c, n3 + n2, c + n);
        }
        for (n4 = 0; n4 < 70; ++n4) {
            n3 = RANDOM.nextInt(this.width - 1);
            int n5 = RANDOM.nextInt(this.height - 1);
            n2 = RANDOM.nextInt(12) + 1;
            n = RANDOM.nextInt(6) + 1;
            graphics.drawLine(n3, n5, n3 - n2, n5 - n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < this.length; ++n3) {
            char c = this.getRandomChar();
            stringBuilder.append(c);
            graphics.setColor(new Color(20 + RANDOM.nextInt(110), 20 + RANDOM.nextInt(110), 20 + RANDOM.nextInt(110)));
            graphics.drawString(String.valueOf(c), 15 * n3 + 10, 16);
        }
        graphics.dispose();
        return new Captcha(stringBuilder.toString(), bufferedImage);
    }

    private char getRandomChar() {
        if (this.characters == null || this.characters.isEmpty()) {
            return (char)(RANDOM.nextInt(26) + 65);
        }
        int n = RANDOM.nextInt(this.characters.length());
        return this.characters.charAt(n);
    }

    private Color getRandomColor(int n, int n2) {
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        int n3 = n + RANDOM.nextInt(n2 - n);
        int n4 = n + RANDOM.nextInt(n2 - n);
        int n5 = n + RANDOM.nextInt(n2 - n);
        return new Color(n3, n4, n5);
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setCharacters(String string) {
        this.characters = string;
    }

    public void setFont(String string) {
        this.font = string;
    }
}

