/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.csv.reader.function;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import spring.turbo.module.csv.reader.function.LinePredicate;
import spring.turbo.util.Asserts;
import spring.turbo.util.SetFactories;

public final class LinePredicateFactories {
    private LinePredicateFactories() {
    }

    public static LinePredicate alwaysTrue() {
        return (n, string) -> true;
    }

    public static LinePredicate alwaysFalse() {
        return (n, string) -> false;
    }

    public static LinePredicate any(LinePredicate ... linePredicateArray) {
        return new Any(linePredicateArray);
    }

    public static LinePredicate all(LinePredicate ... linePredicateArray) {
        return new All(linePredicateArray);
    }

    public static LinePredicate or(LinePredicate linePredicate, LinePredicate linePredicate2) {
        Asserts.notNull((Object)linePredicate);
        Asserts.notNull((Object)linePredicate2);
        return LinePredicateFactories.any(linePredicate, linePredicate2);
    }

    public static LinePredicate and(LinePredicate linePredicate, LinePredicate linePredicate2) {
        Asserts.notNull((Object)linePredicate);
        Asserts.notNull((Object)linePredicate2);
        return LinePredicateFactories.all(linePredicate, linePredicate2);
    }

    public static LinePredicate lineNumbers(Integer ... integerArray) {
        Set set = SetFactories.newUnmodifiableSet((Object[])integerArray);
        return (n, string) -> set.contains(n);
    }

    private static class Any
    implements LinePredicate {
        private final List<LinePredicate> predicates;

        public Any(LinePredicate ... linePredicateArray) {
            Asserts.notNull((Object)linePredicateArray);
            Asserts.noNullElements((Object[])linePredicateArray);
            this.predicates = Arrays.asList(linePredicateArray);
        }

        @Override
        public boolean test(int n, String string) {
            for (LinePredicate linePredicate : this.predicates) {
                if (!linePredicate.test(n, string)) continue;
                return true;
            }
            return false;
        }
    }

    private static class All
    implements LinePredicate {
        private final List<LinePredicate> predicates;

        public All(LinePredicate ... linePredicateArray) {
            Asserts.notNull((Object)linePredicateArray);
            Asserts.noNullElements((Object[])linePredicateArray);
            this.predicates = Arrays.asList(linePredicateArray);
        }

        @Override
        public boolean test(int n, String string) {
            for (LinePredicate linePredicate : this.predicates) {
                if (linePredicate.test(n, string)) continue;
                return false;
            }
            return true;
        }
    }
}

