/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.lang.Nullable;
import spring.turbo.module.dataaccessing.datasource.DynamicDataSourceRemote;
import spring.turbo.util.Asserts;

public class DynamicDataSource
extends AbstractRoutingDataSource
implements InitializingBean {
    private DynamicDataSource(DataSource dataSource, Map<Object, Object> map) {
        super.setDefaultTargetDataSource((Object)dataSource);
        super.setTargetDataSources(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
    }

    @Nullable
    protected Object determineCurrentLookupKey() {
        return DynamicDataSourceRemote.getKey();
    }

    public static class Builder
    implements spring.turbo.bean.Builder<DynamicDataSource> {
        private final Map<Object, Object> targetDataSources = new HashMap<Object, Object>();
        @Nullable
        private DataSource defaultTargetDataSource;

        private Builder() {
        }

        public Builder defaultTargetDataSource(DataSource dataSource) {
            Asserts.notNull((Object)dataSource);
            this.defaultTargetDataSource = dataSource;
            return this;
        }

        public Builder addTargetDataSources(String string, DataSource dataSource) {
            Asserts.hasText((String)string);
            Asserts.notNull((Object)dataSource);
            this.targetDataSources.put(string, dataSource);
            return this;
        }

        public DynamicDataSource build() {
            Asserts.notNull((Object)this.defaultTargetDataSource);
            Asserts.notEmpty(this.targetDataSources);
            return new DynamicDataSource(this.defaultTargetDataSource, this.targetDataSources);
        }
    }
}

