/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.util;

import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import spring.turbo.util.Asserts;
import spring.turbo.util.CharsetPool;

public final class RabbitmqMessageFactories {
    private RabbitmqMessageFactories() {
    }

    public static Message create(String string) {
        return RabbitmqMessageFactories.create(string, Long.MIN_VALUE);
    }

    public static Message create(String string, long l) {
        return RabbitmqMessageFactories.create(string, l, Integer.MIN_VALUE);
    }

    public static Message create(String string, long l, int n) {
        Asserts.notNull((Object)string);
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/octet-stream");
        messageProperties.setDeliveryMode(MessageDeliveryMode.PERSISTENT);
        if (l > 0L) {
            messageProperties.setExpiration(Long.toString(l));
        }
        if (n >= 0) {
            messageProperties.setPriority(Integer.valueOf(n));
        }
        return new Message(string.getBytes(CharsetPool.UTF_8), messageProperties);
    }
}

