/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.util;

import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import spring.turbo.core.SpringUtils;
import spring.turbo.module.dataaccessing.redis.RedisLockKeyCustomizer;
import spring.turbo.util.Asserts;

public final class RedisLockUtils {
    private static final List<String> EMPTY_KEYS = Collections.emptyList();
    private static final RedisLockKeyCustomizer LOCK_KEY_CUSTOMIZER = RedisLockKeyCustomizer.DEFAULT;

    private RedisLockUtils() {
    }

    public static boolean lock(String string, String string2, int n) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        Asserts.isTrue((n >= 1 ? 1 : 0) != 0);
        RedisLockKeyCustomizer redisLockKeyCustomizer = SpringUtils.getBean(RedisLockKeyCustomizer.class).orElse(LOCK_KEY_CUSTOMIZER);
        string = redisLockKeyCustomizer.customize(string);
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtils.getRequiredBean(StringRedisTemplate.class);
        RedisScript redisScript = (RedisScript)SpringUtils.getRequiredBean(RedisScript.class, (String)"redisLockLockLuaScript");
        Boolean bl = (Boolean)stringRedisTemplate.execute(redisScript, EMPTY_KEYS, new Object[]{string, string2, String.valueOf(n)});
        return bl != null ? bl : false;
    }

    public static boolean release(String string, String string2) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        RedisLockKeyCustomizer redisLockKeyCustomizer = SpringUtils.getBean(RedisLockKeyCustomizer.class).orElse(LOCK_KEY_CUSTOMIZER);
        string = redisLockKeyCustomizer.customize(string);
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtils.getRequiredBean(StringRedisTemplate.class);
        RedisScript redisScript = (RedisScript)SpringUtils.getRequiredBean(RedisScript.class, (String)"redisLockReleaseLuaScript");
        Boolean bl = (Boolean)stringRedisTemplate.execute(redisScript, EMPTY_KEYS, new Object[]{string, string2});
        return bl != null ? bl : false;
    }
}

