/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.util;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import spring.turbo.core.SpringUtils;
import spring.turbo.util.Asserts;

public final class ZkLock
implements Serializable {
    private final InterProcessMutex mutex;

    private ZkLock(CuratorFramework curatorFramework, String string) {
        this.mutex = new InterProcessMutex(curatorFramework, string);
    }

    public static ZkLock newInstance(String string) {
        CuratorFramework curatorFramework = (CuratorFramework)SpringUtils.getRequiredBean(CuratorFramework.class);
        Asserts.notNull((Object)curatorFramework);
        return new ZkLock(curatorFramework, string);
    }

    public boolean lock(long l, TimeUnit timeUnit) {
        Asserts.isTrue((l > 0L ? 1 : 0) != 0);
        Asserts.notNull((Object)((Object)timeUnit));
        try {
            return this.mutex.acquire(l, timeUnit);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean release() {
        try {
            this.mutex.release();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

