/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.zookeeper;

import java.io.Closeable;
import java.util.UUID;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.utils.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import spring.turbo.module.dataaccessing.zookeeper.ZkProperties;
import spring.turbo.util.Asserts;

public class LeaderLatchFactory
implements FactoryBean<LeaderLatch>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(LeaderLatchFactory.class);
    private final ZkProperties zkProps;
    private final CuratorFramework zkCli;
    @Nullable
    private LeaderLatch leaderLatch;

    public LeaderLatchFactory(ZkProperties zkProperties, CuratorFramework curatorFramework) {
        Asserts.notNull((Object)zkProperties);
        Asserts.notNull((Object)curatorFramework);
        this.zkProps = zkProperties;
        this.zkCli = curatorFramework;
    }

    @Nullable
    public LeaderLatch getObject() {
        return this.leaderLatch;
    }

    @Nullable
    public Class<?> getObjectType() {
        return LeaderLatch.class;
    }

    public void afterPropertiesSet() throws Exception {
        String string = this.zkProps.getLeaderElection().getNodeId();
        if (string == null) {
            string = UUID.randomUUID().toString();
            log.debug("node-id: {}", (Object)string);
        }
        this.leaderLatch = new LeaderLatch(this.zkCli, this.zkProps.getLeaderElection().getZkPath(), string);
        this.leaderLatch.start();
    }

    public void destroy() {
        CloseableUtils.closeQuietly((Closeable)this.leaderLatch);
    }
}

