/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import spring.turbo.bean.Pair;
import spring.turbo.bean.Tuple;
import spring.turbo.util.Asserts;

public final class HeaderConfig
implements Serializable {
    private final List<Pair<String, Integer>> sheetNameConfig = new ArrayList<Pair<String, Integer>>();
    private final List<Pair<Integer, Integer>> sheetIndexConfig = new ArrayList<Pair<Integer, Integer>>();
    private final List<Tuple<String, Integer, String[]>> sheetNameFixedHeader = new ArrayList<Tuple<String, Integer, String[]>>();
    private final List<Tuple<Integer, Integer, String[]>> sheetIndexFixedHeader = new ArrayList<Tuple<Integer, Integer, String[]>>();

    private HeaderConfig() {
    }

    public static HeaderConfig newInstance() {
        return new HeaderConfig();
    }

    public HeaderConfig bySheetName(String string, int n) {
        Asserts.hasText((String)string);
        Asserts.isTrue((n >= 0 ? 1 : 0) != 0);
        this.sheetNameConfig.add((Pair<String, Integer>)Pair.ofNonNull((Object)string, (Object)n));
        return this;
    }

    public HeaderConfig bySheetIndex(int n, int n2) {
        Asserts.isTrue((n >= 0 ? 1 : 0) != 0);
        Asserts.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.sheetIndexConfig.add((Pair<Integer, Integer>)Pair.ofNonNull((Object)n, (Object)n2));
        return this;
    }

    public HeaderConfig fixed(int n, String ... stringArray) {
        return this.fixed(n, 0, stringArray);
    }

    public HeaderConfig fixed(int n, int n2, String ... stringArray) {
        this.sheetIndexFixedHeader.add((Tuple<Integer, Integer, String[]>)Tuple.ofNullable((Object)n, (Object)n2, (Object)stringArray));
        return this;
    }

    public HeaderConfig fixed(String string, String ... stringArray) {
        return this.fixed(string, 0, stringArray);
    }

    public HeaderConfig fixed(String string, int n, String ... stringArray) {
        this.sheetNameFixedHeader.add((Tuple<String, Integer, String[]>)Tuple.ofNullable((Object)string, (Object)n, (Object)stringArray));
        return this;
    }

    public List<Pair<String, Integer>> getSheetNameConfig() {
        return this.sheetNameConfig;
    }

    public List<Pair<Integer, Integer>> getSheetIndexConfig() {
        return this.sheetIndexConfig;
    }

    public List<Tuple<String, Integer, String[]>> getSheetNameFixedHeader() {
        return this.sheetNameFixedHeader;
    }

    public List<Tuple<Integer, Integer, String[]>> getSheetIndexFixedHeader() {
        return this.sheetIndexFixedHeader;
    }
}

