/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.function;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import spring.turbo.module.datahandling.excel.function.RowPredicate;
import spring.turbo.module.datahandling.excel.util.RowUtils;
import spring.turbo.module.datahandling.excel.util.SheetUtils;
import spring.turbo.util.ArrayUtils;
import spring.turbo.util.Asserts;

public final class RowPredicateFactories {
    private RowPredicateFactories() {
    }

    public static RowPredicate alwaysTrue() {
        return (sheet, row) -> true;
    }

    public static RowPredicate alwaysFalse() {
        return (sheet, row) -> false;
    }

    public static RowPredicate not(RowPredicate rowPredicate) {
        Asserts.notNull((Object)rowPredicate);
        return (sheet, row) -> !rowPredicate.test(sheet, row);
    }

    public static RowPredicate or(RowPredicate rowPredicate, RowPredicate rowPredicate2) {
        Asserts.notNull((Object)rowPredicate);
        Asserts.notNull((Object)rowPredicate2);
        return RowPredicateFactories.any(rowPredicate, rowPredicate2);
    }

    public static RowPredicate and(RowPredicate rowPredicate, RowPredicate rowPredicate2) {
        Asserts.notNull((Object)rowPredicate);
        Asserts.notNull((Object)rowPredicate2);
        return RowPredicateFactories.all(rowPredicate, rowPredicate2);
    }

    public static RowPredicate xor(RowPredicate rowPredicate, RowPredicate rowPredicate2) {
        Asserts.notNull((Object)rowPredicate);
        Asserts.notNull((Object)rowPredicate2);
        return (sheet, row) -> rowPredicate.test(sheet, row) ^ rowPredicate2.test(sheet, row);
    }

    public static RowPredicate any(RowPredicate ... rowPredicateArray) {
        Asserts.notEmpty((Object[])rowPredicateArray);
        Asserts.noNullElements((Object[])rowPredicateArray);
        return new Any(rowPredicateArray);
    }

    public static RowPredicate all(RowPredicate ... rowPredicateArray) {
        Asserts.notEmpty((Object[])rowPredicateArray);
        Asserts.noNullElements((Object[])rowPredicateArray);
        return new All(rowPredicateArray);
    }

    public static RowPredicate indexInSet(String string, Integer ... integerArray) {
        Asserts.hasText((String)string);
        Asserts.notNull((Object)integerArray);
        Asserts.noNullElements((Object[])integerArray);
        return (sheet, row) -> string.equals(SheetUtils.getName(sheet)) && ArrayUtils.contains((Object[])integerArray, (Object)row.getRowNum());
    }

    public static RowPredicate indexInSet(int n, Integer ... integerArray) {
        Asserts.isTrue((n >= 0 ? 1 : 0) != 0);
        Asserts.notNull((Object)integerArray);
        Asserts.noNullElements((Object[])integerArray);
        return (sheet, row) -> n == SheetUtils.getIndex(sheet) && ArrayUtils.contains((Object[])integerArray, (Object)row.getRowNum());
    }

    public static RowPredicate indexInRange(String string, int n, int n2) {
        Asserts.hasText((String)string);
        Asserts.isTrue((n <= n2 ? 1 : 0) != 0);
        return (sheet, row) -> {
            int n3 = row.getRowNum();
            return string.equals(SheetUtils.getName(sheet)) && n3 >= n && n3 < n2;
        };
    }

    public static RowPredicate indexInRange(int n, int n2, int n3) {
        Asserts.isTrue((n >= 0 ? 1 : 0) != 0);
        Asserts.isTrue((n2 <= n3 ? 1 : 0) != 0);
        return (sheet, row) -> {
            int n4 = row.getRowNum();
            return n == SheetUtils.getIndex(sheet) && n4 >= n2 && n4 < n3;
        };
    }

    public static RowPredicate isZeroHeight() {
        return (sheet, row) -> RowUtils.isZeroHeight(row);
    }

    public static RowPredicate isNotZeroHeight() {
        return (sheet, row) -> RowUtils.isNotZeroHeight(row);
    }

    public static RowPredicate isFormatted() {
        return (sheet, row) -> RowUtils.isFormatted(row);
    }

    public static RowPredicate isNotFormatted() {
        return (sheet, row) -> RowUtils.isNotFormatted(row);
    }

    private static class Any
    implements RowPredicate {
        private final List<RowPredicate> predicates = new LinkedList<RowPredicate>();

        private Any(RowPredicate ... rowPredicateArray) {
            Collections.addAll(this.predicates, rowPredicateArray);
        }

        @Override
        public boolean test(Sheet sheet, Row row) {
            return this.predicates.stream().anyMatch(rowPredicate -> rowPredicate.test(sheet, row));
        }
    }

    private static class All
    implements RowPredicate {
        private final List<RowPredicate> predicates = new LinkedList<RowPredicate>();

        private All(RowPredicate ... rowPredicateArray) {
            Collections.addAll(this.predicates, rowPredicateArray);
        }

        @Override
        public boolean test(Sheet sheet, Row row) {
            return this.predicates.stream().allMatch(rowPredicate -> rowPredicate.test(sheet, row));
        }
    }
}

