/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Sheet;
import spring.turbo.module.datahandling.excel.function.SheetPredicate;
import spring.turbo.module.datahandling.excel.util.SheetUtils;
import spring.turbo.util.Asserts;

public final class SheetPredicateFactories {
    private SheetPredicateFactories() {
    }

    public static SheetPredicate alwaysTrue() {
        return sheet -> true;
    }

    public static SheetPredicate alwaysFalse() {
        return sheet -> false;
    }

    public static SheetPredicate not(SheetPredicate sheetPredicate) {
        Asserts.notNull((Object)sheetPredicate);
        return sheet -> !sheetPredicate.test(sheet);
    }

    public static SheetPredicate or(SheetPredicate sheetPredicate, SheetPredicate sheetPredicate2) {
        Asserts.notNull((Object)sheetPredicate);
        Asserts.notNull((Object)sheetPredicate2);
        return SheetPredicateFactories.any(sheetPredicate, sheetPredicate2);
    }

    public static SheetPredicate and(SheetPredicate sheetPredicate, SheetPredicate sheetPredicate2) {
        Asserts.notNull((Object)sheetPredicate);
        Asserts.notNull((Object)sheetPredicate2);
        return SheetPredicateFactories.all(sheetPredicate, sheetPredicate2);
    }

    public static SheetPredicate xor(SheetPredicate sheetPredicate, SheetPredicate sheetPredicate2) {
        Asserts.notNull((Object)sheetPredicate);
        Asserts.notNull((Object)sheetPredicate2);
        return sheet -> sheetPredicate.test(sheet) ^ sheetPredicate2.test(sheet);
    }

    public static SheetPredicate any(SheetPredicate ... sheetPredicateArray) {
        Asserts.notEmpty((Object[])sheetPredicateArray);
        Asserts.noNullElements((Object[])sheetPredicateArray);
        return new Any(sheetPredicateArray);
    }

    public static SheetPredicate all(SheetPredicate ... sheetPredicateArray) {
        Asserts.notEmpty((Object[])sheetPredicateArray);
        Asserts.noNullElements((Object[])sheetPredicateArray);
        return new All(sheetPredicateArray);
    }

    public static SheetPredicate ofName(String ... stringArray) {
        Asserts.notEmpty((Object[])stringArray);
        Asserts.noNullElements((Object[])stringArray);
        return sheet -> Stream.of(stringArray).anyMatch(string -> sheet.getSheetName().equals(string));
    }

    public static SheetPredicate ofNamePattern(String string) {
        Asserts.hasText((String)string);
        return sheet -> sheet.getSheetName().matches(string);
    }

    public static SheetPredicate ofIndex(Integer ... integerArray) {
        Asserts.notEmpty((Object[])integerArray);
        Asserts.noNullElements((Object[])integerArray);
        return sheet -> {
            int n = sheet.getWorkbook().getSheetIndex(sheet);
            return Arrays.asList(integerArray).contains(n);
        };
    }

    public static SheetPredicate isHidden() {
        return SheetUtils::isHidden;
    }

    public static SheetPredicate isVisitable() {
        return SheetUtils::isVisitable;
    }

    private static class Any
    implements SheetPredicate {
        private final List<SheetPredicate> predicates = new LinkedList<SheetPredicate>();

        private Any(SheetPredicate ... sheetPredicateArray) {
            Collections.addAll(this.predicates, sheetPredicateArray);
        }

        @Override
        public boolean test(Sheet sheet) {
            return this.predicates.stream().anyMatch(sheetPredicate -> sheetPredicate.test(sheet));
        }
    }

    private static class All
    implements SheetPredicate {
        private final List<SheetPredicate> predicates = new LinkedList<SheetPredicate>();

        private All(SheetPredicate ... sheetPredicateArray) {
            Collections.addAll(this.predicates, sheetPredicateArray);
        }

        @Override
        public boolean test(Sheet sheet) {
            return this.predicates.stream().allMatch(sheetPredicate -> sheetPredicate.test(sheet));
        }
    }
}

