/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.validation.Validator;
import spring.turbo.bean.Pair;
import spring.turbo.bean.Tuple;
import spring.turbo.bean.valueobject.Alias;
import spring.turbo.bean.valueobject.NullValidator;
import spring.turbo.bean.valueobject.ProcessPayload;
import spring.turbo.bean.valueobject.ValueObjectFilter;
import spring.turbo.core.AnnotationUtils;
import spring.turbo.core.SpringContext;
import spring.turbo.core.SpringContextAware;
import spring.turbo.module.datahandling.excel.ExcelType;
import spring.turbo.module.datahandling.excel.cellparser.CellParser;
import spring.turbo.module.datahandling.excel.cellparser.DefaultCellParser;
import spring.turbo.module.datahandling.excel.config.AliasConfig;
import spring.turbo.module.datahandling.excel.function.RowPredicateFactories;
import spring.turbo.module.datahandling.excel.function.SheetPredicateFactories;
import spring.turbo.module.datahandling.excel.reader.BatchValueObjectReadingTrigger;
import spring.turbo.module.datahandling.excel.reader.BatchWalker;
import spring.turbo.module.datahandling.excel.reader.BuilderCustomizer;
import spring.turbo.module.datahandling.excel.reader.ExcelDiscriminator;
import spring.turbo.module.datahandling.excel.reader.NullPasswordProvider;
import spring.turbo.module.datahandling.excel.reader.PasswordProvider;
import spring.turbo.module.datahandling.excel.reader.ProcessingResult;
import spring.turbo.module.datahandling.excel.reader.annotation.AdditionalValidators;
import spring.turbo.module.datahandling.excel.reader.annotation.BatchProcessor;
import spring.turbo.module.datahandling.excel.reader.annotation.BatchSize;
import spring.turbo.module.datahandling.excel.reader.annotation.ColumnBasedCellParser;
import spring.turbo.module.datahandling.excel.reader.annotation.Customizer;
import spring.turbo.module.datahandling.excel.reader.annotation.ExcludeRowRange;
import spring.turbo.module.datahandling.excel.reader.annotation.ExcludeRowSet;
import spring.turbo.module.datahandling.excel.reader.annotation.Filter;
import spring.turbo.module.datahandling.excel.reader.annotation.GlobalCellParser;
import spring.turbo.module.datahandling.excel.reader.annotation.Header;
import spring.turbo.module.datahandling.excel.reader.annotation.Headerless;
import spring.turbo.module.datahandling.excel.reader.annotation.IncludeSheetPattern;
import spring.turbo.module.datahandling.excel.reader.annotation.IncludeSheetSet;
import spring.turbo.module.datahandling.excel.reader.annotation.Password;
import spring.turbo.module.datahandling.excel.reader.annotation.Type;
import spring.turbo.module.datahandling.excel.visitor.BatchVisitor;
import spring.turbo.util.ArrayUtils;
import spring.turbo.util.Asserts;
import spring.turbo.util.ExpressionUtils;
import spring.turbo.util.InstanceCache;
import spring.turbo.util.StringFormatter;
import spring.turbo.util.StringUtils;

public class BatchValueObjectReadingTriggerImpl
implements BatchValueObjectReadingTrigger,
InitializingBean,
SpringContextAware {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final List<BatchVisitor<?>> visitors;
    private final Map<String, Config> configMap = new HashMap<String, Config>();
    private InstanceCache instanceCache;
    private ApplicationContext applicationContext;
    private ConversionService conversionService;
    private Validator injectedValidator;

    public BatchValueObjectReadingTriggerImpl(List<BatchVisitor<?>> list) {
        this.visitors = list;
    }

    @Override
    public ProcessingResult fire(ExcelDiscriminator excelDiscriminator, Resource resource, ProcessPayload processPayload) {
        Asserts.notNull((Object)excelDiscriminator);
        String string = excelDiscriminator.getDiscriminatorValue();
        Config config = Optional.ofNullable(this.configMap.get(string)).orElseThrow(() -> new IllegalArgumentException(StringFormatter.format((String)"visitor not found. discriminatorValue: {}", (Object)excelDiscriminator)));
        BatchWalker.Builder builder = BatchWalker.builder(config.valueObjectType).visitor(config.visitor).resource(resource).payload(processPayload).batchSize(config.batchSize).excelType(config.excelType).conversionService(this.conversionService).globalCellParser(config.globalCellParser).valueObjectFilter(config.valueObjectFilter);
        if (this.injectedValidator != null && this.injectedValidator.supports(config.valueObjectType)) {
            builder.setValidators(this.injectedValidator);
        }
        if (StringUtils.isNotBlank((String)config.password)) {
            builder.password(config.password);
        } else if (config.passwordProvider != null) {
            builder.password(config.passwordProvider.getPassword(excelDiscriminator, resource, processPayload));
        }
        for (Pair<Integer, Integer> object : config.headers) {
            builder.setHeader((Integer)object.getA(), (Integer)object.getB());
        }
        for (Tuple tuple : config.headerlessList) {
            builder.setFixedHeader((int)((Integer)tuple.getA()), (Integer)tuple.getB(), (String[])tuple.getC());
        }
        for (Pair pair : config.excludeRowSets) {
            builder.addExcludeRow(RowPredicateFactories.indexInSet((Integer)pair.getA(), ((Set)pair.getB()).toArray(new Integer[0])));
        }
        for (Tuple tuple : config.excludeRowRanges) {
            builder.addExcludeRow(RowPredicateFactories.indexInRange((Integer)tuple.getA(), (int)((Integer)tuple.getB()), (int)((Integer)tuple.getC())));
        }
        for (Tuple tuple : config.columnBasedCellParsers) {
            builder.setColumnBasedCellParser((Integer)tuple.getA(), (Integer)tuple.getB(), (CellParser)tuple.getC());
        }
        if (!CollectionUtils.isEmpty(config.includeSheetSet)) {
            builder.addIncludeSheet(SheetPredicateFactories.ofIndex(config.includeSheetSet.toArray(new Integer[0])));
        }
        if (StringUtils.isNotBlank((String)config.includeSheetPattern)) {
            builder.addIncludeSheet(SheetPredicateFactories.ofNamePattern(config.includeSheetPattern));
        }
        if (!CollectionUtils.isEmpty((Map)config.aliasConfig)) {
            for (String string2 : config.aliasConfig.keySet()) {
                String string3 = (String)config.aliasConfig.get(string2);
                builder.setAlias(string2, string3);
            }
        }
        if (!CollectionUtils.isEmpty(config.additionalValidators)) {
            config.additionalValidators.forEach(validator -> builder.setValidators((Validator)validator));
        }
        if (config.builderCustomizer != null) {
            builder = config.builderCustomizer.customize(builder);
        }
        return ((BatchWalker)builder.build()).walk();
    }

    public void setSpringContext(SpringContext springContext) {
        this.applicationContext = springContext.getApplicationContext();
        this.conversionService = springContext.getBean(ConversionService.class).orElseGet(DefaultFormattingConversionService::new);
        this.injectedValidator = springContext.getBean(Validator.class).orElseGet(NullValidator::getInstance);
        this.instanceCache = InstanceCache.newInstance((ApplicationContext)springContext.getApplicationContext());
    }

    public void afterPropertiesSet() {
        for (BatchVisitor<?> batchVisitor : this.visitors) {
            Config config;
            if (batchVisitor == null || (config = this.parseConfig(batchVisitor)) == null) continue;
            this.configMap.put(config.discriminatorValue, config);
        }
    }

    private Config parseConfig(@Nullable BatchVisitor<?> batchVisitor) {
        if (batchVisitor == null) {
            return null;
        }
        Class<?> clazz = batchVisitor.getClass();
        BatchProcessor batchProcessor = (BatchProcessor)AnnotationUtils.findAnnotation(clazz, BatchProcessor.class);
        if (batchProcessor == null) {
            return null;
        }
        Config config = new Config();
        config.visitor = batchVisitor;
        config.discriminatorValue = batchProcessor.discriminatorValue();
        config.valueObjectType = batchProcessor.valueObjectType();
        config.batchSize = this.getBatchSize(clazz);
        config.headers = this.getHeader(clazz);
        config.headerlessList = this.getHeaderlessList(clazz);
        config.includeSheetSet = this.getIncludeSheetSet(clazz);
        config.includeSheetPattern = this.getIncludeSheetPattern(clazz);
        config.password = this.getPassword(clazz);
        config.passwordProvider = this.getPasswordProvider(clazz);
        config.excelType = this.getExcelType(clazz);
        config.excludeRowSets = this.getExcludeRowSets(clazz);
        config.excludeRowRanges = this.getExcludeRowRanges(clazz);
        config.globalCellParser = this.getGlobalCellParser(clazz);
        config.columnBasedCellParsers = this.getColumnBasedCellParser(clazz);
        config.aliasConfig = this.getAliasConfig(clazz);
        config.additionalValidators = this.getAdditionalValidators(clazz);
        config.valueObjectFilter = this.getValueObjectFilter(clazz);
        config.builderCustomizer = this.getBuilderCustomizer(clazz);
        return config;
    }

    private int getBatchSize(Class<?> clazz) {
        BatchSize batchSize = (BatchSize)AnnotationUtils.findAnnotation(clazz, BatchSize.class);
        if (batchSize == null) {
            return 1000;
        }
        int n = batchSize.value();
        if (n >= 1) {
            return n;
        }
        Object object = ExpressionUtils.getValue((Object)this.applicationContext, (String)batchSize.expression());
        if (object == null) {
            throw new ClassCastException(StringFormatter.format((String)"cannot cast null to int"));
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return (Integer)NumberUtils.parseNumber((String)((String)object), Integer.class);
        }
        throw new ClassCastException(StringFormatter.format((String)"cannot cast {} to int", object.getClass()));
    }

    private List<Pair<Integer, Integer>> getHeader(Class<?> clazz) {
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        Header.List list = (Header.List)AnnotationUtils.findAnnotation(clazz, Header.List.class);
        if (list != null) {
            for (Header header : list.value()) {
                arrayList.add((Pair<Integer, Integer>)Pair.ofNonNull((Object)header.sheetIndex(), (Object)header.rowIndex()));
            }
        } else {
            Header header = (Header)AnnotationUtils.findAnnotation(clazz, Header.class);
            if (header != null) {
                arrayList.add((Pair<Integer, Integer>)Pair.ofNonNull((Object)header.sheetIndex(), (Object)header.rowIndex()));
            }
        }
        return arrayList;
    }

    private List<Tuple<Integer, Integer, String[]>> getHeaderlessList(Class<?> clazz) {
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        Headerless.List list = (Headerless.List)AnnotationUtils.findAnnotation(clazz, Headerless.List.class);
        if (list != null) {
            for (Headerless headerless : list.value()) {
                arrayList.add(Tuple.ofNullable((Object)headerless.sheetIndex(), (Object)headerless.offset(), (Object)headerless.fixed()));
            }
        } else {
            Headerless headerless = (Headerless)AnnotationUtils.findAnnotation(clazz, Headerless.class);
            if (headerless != null) {
                arrayList.add(Tuple.ofNullable((Object)headerless.sheetIndex(), (Object)headerless.offset(), (Object)headerless.fixed()));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Set<Integer> getIncludeSheetSet(Class<?> clazz) {
        IncludeSheetSet includeSheetSet = (IncludeSheetSet)AnnotationUtils.findAnnotation(clazz, IncludeSheetSet.class);
        if (includeSheetSet == null) {
            return Collections.emptySet();
        }
        Set set = Arrays.stream(includeSheetSet.sheetIndexes()).boxed().collect(Collectors.toSet());
        return Collections.unmodifiableSet(set);
    }

    @Nullable
    private String getIncludeSheetPattern(Class<?> clazz) {
        IncludeSheetPattern includeSheetPattern = (IncludeSheetPattern)AnnotationUtils.findAnnotation(clazz, IncludeSheetPattern.class);
        return includeSheetPattern != null ? includeSheetPattern.value() : null;
    }

    @Nullable
    private String getPassword(Class<?> clazz) {
        Password password = (Password)AnnotationUtils.findAnnotation(clazz, Password.class);
        if (password == null) {
            return null;
        }
        String string = password.value();
        return StringUtils.isEmpty((String)string) ? null : string;
    }

    @Nullable
    private PasswordProvider getPasswordProvider(Class<?> clazz) {
        Password password = (Password)AnnotationUtils.findAnnotation(clazz, Password.class);
        if (password == null) {
            return null;
        }
        Class<? extends PasswordProvider> clazz2 = password.provider();
        if (clazz2 == NullPasswordProvider.class) {
            return null;
        }
        return (PasswordProvider)this.instanceCache.findOrCreate(clazz2);
    }

    private ExcelType getExcelType(Class<?> clazz) {
        Type type = (Type)AnnotationUtils.findAnnotation(clazz, Type.class);
        if (type == null) {
            return ExcelType.XSSF;
        }
        return type.value();
    }

    private List<Pair<Integer, Set<Integer>>> getExcludeRowSets(Class<?> clazz) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ExcludeRowSet.List list = (ExcludeRowSet.List)AnnotationUtils.findAnnotation(clazz, ExcludeRowSet.List.class);
        if (list != null) {
            for (ExcludeRowSet excludeRowSet : list.value()) {
                Set set = Arrays.stream(excludeRowSet.rowIndexes()).boxed().collect(Collectors.toSet());
                arrayList.add(Pair.ofNonNull((Object)excludeRowSet.sheetIndex(), set));
            }
        } else {
            ExcludeRowSet excludeRowSet = (ExcludeRowSet)AnnotationUtils.findAnnotation(clazz, ExcludeRowSet.class);
            if (excludeRowSet != null) {
                Set set = Arrays.stream(excludeRowSet.rowIndexes()).boxed().collect(Collectors.toSet());
                arrayList.add(Pair.ofNonNull((Object)excludeRowSet.sheetIndex(), set));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<Tuple<Integer, Integer, Integer>> getExcludeRowRanges(Class<?> clazz) {
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        ExcludeRowRange.List list = (ExcludeRowRange.List)AnnotationUtils.findAnnotation(clazz, ExcludeRowRange.List.class);
        if (list != null) {
            for (ExcludeRowRange excludeRowRange : list.value()) {
                arrayList.add(Tuple.ofNullable((Object)excludeRowRange.sheetIndex(), (Object)excludeRowRange.minInclude(), (Object)excludeRowRange.maxExclude()));
            }
        } else {
            ExcludeRowRange excludeRowRange = (ExcludeRowRange)AnnotationUtils.findAnnotation(clazz, ExcludeRowRange.class);
            if (excludeRowRange != null) {
                arrayList.add(Tuple.ofNullable((Object)excludeRowRange.sheetIndex(), (Object)excludeRowRange.minInclude(), (Object)excludeRowRange.maxExclude()));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private spring.turbo.module.datahandling.excel.cellparser.GlobalCellParser getGlobalCellParser(Class<?> clazz) {
        GlobalCellParser globalCellParser = (GlobalCellParser)AnnotationUtils.findAnnotation(clazz, GlobalCellParser.class);
        if (globalCellParser != null) {
            return (spring.turbo.module.datahandling.excel.cellparser.GlobalCellParser)this.instanceCache.findOrCreate(globalCellParser.type());
        }
        return new DefaultCellParser();
    }

    private AliasConfig getAliasConfig(Class<?> clazz) {
        AliasConfig aliasConfig = AliasConfig.newInstance();
        Alias.List list = (Alias.List)AnnotationUtils.findAnnotation(clazz, Alias.List.class);
        if (list != null) {
            for (Alias alias : list.value()) {
                String string = alias.from();
                String string2 = alias.to();
                if ("#<no value!!!>#".equals(string) || "#<no value!!!>#".equals(string2)) continue;
                aliasConfig.put(string, string2);
            }
        } else {
            Alias alias = (Alias)AnnotationUtils.findAnnotation(clazz, Alias.class);
            if (alias != null) {
                String string = alias.from();
                String string3 = alias.to();
                if (!"#<no value!!!>#".equals(string) && !"#<no value!!!>#".equals(string3)) {
                    aliasConfig.put(string, string3);
                }
            }
        }
        return aliasConfig;
    }

    private List<Tuple<Integer, Integer, CellParser>> getColumnBasedCellParser(Class<?> clazz) {
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        ColumnBasedCellParser.List list = (ColumnBasedCellParser.List)AnnotationUtils.findAnnotation(clazz, ColumnBasedCellParser.List.class);
        if (list != null) {
            for (ColumnBasedCellParser columnBasedCellParser : list.value()) {
                arrayList.add(Tuple.of((Object)columnBasedCellParser.sheetIndex(), (Object)columnBasedCellParser.columnIndex(), (Object)((CellParser)this.instanceCache.findOrCreate(columnBasedCellParser.type()))));
            }
        } else {
            ColumnBasedCellParser columnBasedCellParser = (ColumnBasedCellParser)AnnotationUtils.findAnnotation(clazz, ColumnBasedCellParser.class);
            if (columnBasedCellParser != null) {
                arrayList.add(Tuple.of((Object)columnBasedCellParser.sheetIndex(), (Object)columnBasedCellParser.columnIndex(), (Object)((CellParser)this.instanceCache.findOrCreate(columnBasedCellParser.type()))));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<Validator> getAdditionalValidators(Class<?> clazz2) {
        AdditionalValidators additionalValidators = (AdditionalValidators)AnnotationUtils.findAnnotation(clazz2, AdditionalValidators.class);
        if (additionalValidators != null && !ArrayUtils.isNullOrEmpty((Object[])additionalValidators.value())) {
            return Arrays.stream(additionalValidators.value()).map(clazz -> (Validator)this.instanceCache.findOrCreate(clazz)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    private ValueObjectFilter getValueObjectFilter(Class<?> clazz) {
        Filter filter = (Filter)AnnotationUtils.findAnnotation(clazz, Filter.class);
        if (filter != null) {
            return (ValueObjectFilter)this.instanceCache.findOrCreate(filter.type());
        }
        return null;
    }

    private BuilderCustomizer getBuilderCustomizer(Class<?> clazz) {
        Customizer customizer = (Customizer)AnnotationUtils.findAnnotation(clazz, Customizer.class);
        return customizer != null ? (BuilderCustomizer)this.instanceCache.findOrCreate(customizer.type()) : null;
    }

    private static class Config {
        private BatchVisitor visitor;
        private String discriminatorValue;
        private Class<?> valueObjectType;
        private int batchSize;
        private List<Pair<Integer, Integer>> headers;
        private List<Tuple<Integer, Integer, String[]>> headerlessList;
        private Set<Integer> includeSheetSet;
        private String includeSheetPattern;
        private String password;
        private PasswordProvider passwordProvider;
        private ExcelType excelType;
        private List<Pair<Integer, Set<Integer>>> excludeRowSets;
        private List<Tuple<Integer, Integer, Integer>> excludeRowRanges;
        private spring.turbo.module.datahandling.excel.cellparser.GlobalCellParser globalCellParser;
        private List<Tuple<Integer, Integer, CellParser>> columnBasedCellParsers;
        private AliasConfig aliasConfig;
        private List<Validator> additionalValidators;
        private ValueObjectFilter valueObjectFilter;
        private BuilderCustomizer builderCustomizer;

        private Config() {
        }
    }
}

