/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.reader;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.Resource;
import spring.turbo.module.datahandling.excel.ExcelType;
import spring.turbo.module.datahandling.excel.reader.WorkbookAndFileSystem;

public final class WorkbookResourceUtils {
    private WorkbookResourceUtils() {
    }

    public static WorkbookAndFileSystem createWorkbook(ExcelType excelType, Resource resource, String string) throws IOException, GeneralSecurityException {
        if (string == null) {
            if (excelType == ExcelType.XSSF) {
                return new WorkbookAndFileSystem((Workbook)new XSSFWorkbook(resource.getInputStream()));
            }
            return new WorkbookAndFileSystem((Workbook)new HSSFWorkbook(resource.getInputStream()));
        }
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(resource.getInputStream());
        if (excelType == ExcelType.XSSF) {
            EncryptionInfo encryptionInfo = new EncryptionInfo(pOIFSFileSystem);
            Decryptor decryptor = Decryptor.getInstance((EncryptionInfo)encryptionInfo);
            if (!decryptor.verifyPassword(string)) {
                throw new IllegalArgumentException("unable to process: wrong password");
            }
            return new WorkbookAndFileSystem((Workbook)new XSSFWorkbook(decryptor.getDataStream(pOIFSFileSystem)), pOIFSFileSystem);
        }
        Biff8EncryptionKey.setCurrentUserPassword((String)string);
        return new WorkbookAndFileSystem((Workbook)new HSSFWorkbook(pOIFSFileSystem), pOIFSFileSystem);
    }
}

