/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.util;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import spring.turbo.bean.Pair;
import spring.turbo.util.Asserts;

public final class RowUtils {
    private RowUtils() {
    }

    public static Pair<Workbook, Sheet> getParent(Row row) {
        Asserts.notNull((Object)row);
        Sheet sheet = row.getSheet();
        Workbook workbook = sheet.getWorkbook();
        return Pair.ofNonNull((Object)workbook, (Object)sheet);
    }

    public static int getIndex(Row row) {
        Asserts.notNull((Object)row);
        return row.getRowNum();
    }

    public static boolean isZeroHeight(Row row) {
        Asserts.notNull((Object)row);
        return row.getZeroHeight();
    }

    public static boolean isNotZeroHeight(Row row) {
        return !RowUtils.isZeroHeight(row);
    }

    public static boolean isFormatted(Row row) {
        Asserts.notNull((Object)row);
        return row.isFormatted();
    }

    public static boolean isNotFormatted(Row row) {
        return !RowUtils.isFormatted(row);
    }
}

