/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import spring.turbo.core.AnnotationUtils;
import spring.turbo.module.datahandling.excel.style.StyleProvider;
import spring.turbo.module.datahandling.excel.writer.annotation.DataStyle;
import spring.turbo.module.datahandling.excel.writer.annotation.DateTypeDataStyle;
import spring.turbo.module.datahandling.excel.writer.annotation.Header;
import spring.turbo.module.datahandling.excel.writer.annotation.HeaderStyle;
import spring.turbo.module.datahandling.excel.writer.annotation.InlineHeader;
import spring.turbo.module.datahandling.excel.writer.annotation.Offset;
import spring.turbo.util.Asserts;
import spring.turbo.util.CollectionUtils;
import spring.turbo.util.InstanceCache;
import spring.turbo.util.StringUtils;

public final class SheetMetadata<T>
implements Serializable,
Ordered {
    private final Class<T> valueObjectType;
    private final int sheetIndex;
    private final String sheetName;
    private final Collection<T> data;
    private final Set<String> includeHeaders;

    private SheetMetadata(Class<T> clazz, int n, String string, @Nullable Collection<T> collection, @Nullable Set<String> set) {
        Asserts.notNull(clazz);
        Asserts.isTrue((n >= 0 ? 1 : 0) != 0);
        Asserts.hasText((String)string);
        this.valueObjectType = clazz;
        this.sheetIndex = n;
        this.sheetName = string;
        this.data = CollectionUtils.isEmpty(collection) ? Collections.emptyList() : collection;
        this.includeHeaders = CollectionUtils.isEmpty(set) ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    static <T> SheetMetadata<T> newInstance(Class<T> clazz, int n, String string, @Nullable Collection<T> collection, @Nullable Set<String> set) {
        return new SheetMetadata<T>(clazz, n, string, collection, set);
    }

    public Class<T> getValueObjectType() {
        return this.valueObjectType;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public Collection<T> getData() {
        return this.data;
    }

    public Set<String> getIncludeHeaders() {
        return this.includeHeaders;
    }

    public int getOrder() {
        return this.getSheetIndex();
    }

    public boolean shouldSkip(String string) {
        if (CollectionUtils.isEmpty(this.includeHeaders)) {
            return false;
        }
        return !this.includeHeaders.contains(string);
    }

    @NonNull
    public List<String> getHeader() {
        Header header;
        List<Object> list = new ArrayList();
        InlineHeader inlineHeader = (InlineHeader)AnnotationUtils.findAnnotation(this.valueObjectType, InlineHeader.class);
        if (inlineHeader != null) {
            StringUtils.blankSafeAddAll(list, (String[])inlineHeader.value().split("[\\s,]+"));
        }
        if ((header = (Header)AnnotationUtils.findAnnotation(this.valueObjectType, Header.class)) != null) {
            CollectionUtils.nullSafeAddAll(list, (Object[])header.value());
            if (header.trim()) {
                list = list.stream().map(String::trim).collect(Collectors.toList());
            }
        }
        return Collections.unmodifiableList(list);
    }

    public int getOffset() {
        Offset offset = (Offset)AnnotationUtils.findAnnotation(this.valueObjectType, Offset.class);
        int n = Optional.ofNullable(offset).map(Offset::value).orElse(0);
        return Math.max(n, 0);
    }

    @Nullable
    public StyleProvider getHeaderStyleProvider(InstanceCache instanceCache) {
        HeaderStyle headerStyle = (HeaderStyle)AnnotationUtils.findAnnotation(this.valueObjectType, HeaderStyle.class);
        if (headerStyle == null) {
            return null;
        }
        return (StyleProvider)instanceCache.findOrCreate(headerStyle.type());
    }

    @Nullable
    public StyleProvider getCommonDataStyleProvider(InstanceCache instanceCache) {
        DataStyle dataStyle = (DataStyle)AnnotationUtils.findAnnotation(this.valueObjectType, DataStyle.class);
        if (dataStyle == null) {
            return null;
        }
        return (StyleProvider)instanceCache.findOrCreate(dataStyle.type());
    }

    @Nullable
    public StyleProvider getDateTypeDataStyleProvider(InstanceCache instanceCache) {
        DateTypeDataStyle dateTypeDataStyle = (DateTypeDataStyle)AnnotationUtils.findAnnotation(this.valueObjectType, DateTypeDataStyle.class);
        if (dateTypeDataStyle == null) {
            return null;
        }
        return (StyleProvider)instanceCache.findOrCreate(dateTypeDataStyle.type());
    }
}

