/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datasource;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import spring.turbo.core.AnnotationUtils;
import spring.turbo.module.datasource.DataSourceSwitch;
import spring.turbo.module.datasource.DynamicDataSourceRemote;

@Aspect
@Order(value=-2147483648)
public class DataSourceSwitchingAdvice {
    private static final Logger log = LoggerFactory.getLogger(DataSourceSwitchingAdvice.class);
    private static final Class<DataSourceSwitch> ANNOTATION_TYPE = DataSourceSwitch.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(spring.turbo.module.datasource.DataSourceSwitch)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        DataSourceSwitch dataSourceSwitch = (DataSourceSwitch)AnnotationUtils.findAnnotation((Method)method, ANNOTATION_TYPE);
        if (dataSourceSwitch != null) {
            object = dataSourceSwitch.value();
            log.info("switch datasource to '{}'", object);
            DynamicDataSourceRemote.setKey((String)object);
        } else {
            log.info("switch datasource to default");
        }
        try {
            object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            DynamicDataSourceRemote.clear();
        }
    }
}

