/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.predefined;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import spring.turbo.bean.Pair;
import spring.turbo.io.ResourceOptions;
import spring.turbo.util.Asserts;
import spring.turbo.util.crypto.DSA;
import spring.turbo.util.crypto.DSAKeys;

public final class PredefinedDSA {
    private PredefinedDSA() {
    }

    public static Pair<String, String> loadKeys(int n) {
        Asserts.isTrue((n >= 0 && n <= 9 ? 1 : 0) != 0, (String)"i must be in range [0,10)");
        String string = ResourceOptions.fromSeparatedLocations((String)String.format("classpath:dsa/dsa.public.%d.txt", n)).toString(StandardCharsets.UTF_8);
        String string2 = ResourceOptions.fromSeparatedLocations((String)String.format("classpath:dsa/dsa.private.%d.txt", n)).toString(StandardCharsets.UTF_8);
        return Pair.of((Object)string, (Object)string2);
    }

    public static DSA createCrypto(int n) {
        Pair<String, String> pair = PredefinedDSA.loadKeys(n);
        return DSA.builder().keyPair(DSAKeys.fromString((String)((String)Objects.requireNonNull(pair.getA())), (String)((String)Objects.requireNonNull(pair.getB())))).build();
    }
}

