/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.predefined;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import spring.turbo.bean.Pair;
import spring.turbo.io.ResourceOptions;
import spring.turbo.util.Asserts;
import spring.turbo.util.crypto.RSA;
import spring.turbo.util.crypto.RSAKeys;

public final class PredefinedRSA {
    private PredefinedRSA() {
    }

    public static Pair<String, String> loadKeys(int n) {
        Asserts.isTrue((n >= 0 && n <= 9 ? 1 : 0) != 0, (String)"i must be in range [0,10)");
        String string = ResourceOptions.fromSeparatedLocations((String)String.format("classpath:rsa/rsa.public.%d.txt", n)).toString(StandardCharsets.UTF_8);
        String string2 = ResourceOptions.fromSeparatedLocations((String)String.format("classpath:rsa/rsa.private.%d.txt", n)).toString(StandardCharsets.UTF_8);
        return Pair.of((Object)string, (Object)string2);
    }

    public static RSA createCrypto(int n) {
        Pair<String, String> pair = PredefinedRSA.loadKeys(n);
        return RSA.builder().keyPair(RSAKeys.fromString((String)((String)Objects.requireNonNull(pair.getA())), (String)((String)Objects.requireNonNull(pair.getB())))).build();
    }
}

