/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector;

import java.util.HashSet;
import java.util.Set;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import spring.turbo.bean.Builder;
import spring.turbo.module.queryselector.DataType;
import spring.turbo.module.queryselector.LogicType;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.SelectorImpl;
import spring.turbo.util.Asserts;
import spring.turbo.util.CollectionUtils;

public final class SelectorBuilder
implements Builder<Selector> {
    @NonNull
    private final Set<Object> setValue = new HashSet<Object>();
    @Nullable
    private String itemName;
    @Nullable
    private DataType dataType;
    @Nullable
    private LogicType logicType;
    @Nullable
    private Object simpleValue;
    @Nullable
    private Object rangeLeft;
    @Nullable
    private Object rangeRight;

    private SelectorBuilder() {
    }

    public static SelectorBuilder newInstance() {
        return new SelectorBuilder();
    }

    public SelectorBuilder itemName(String string) {
        Asserts.hasText((String)string);
        this.itemName = string;
        return this;
    }

    public SelectorBuilder logicType(LogicType logicType) {
        Asserts.notNull((Object)logicType);
        this.logicType = logicType;
        return this;
    }

    public SelectorBuilder dataType(DataType dataType) {
        Asserts.notNull((Object)dataType);
        this.dataType = dataType;
        return this;
    }

    public SelectorBuilder simpleValue(Object object) {
        Asserts.notNull((Object)object);
        this.simpleValue = object;
        return this;
    }

    public SelectorBuilder rangeValue(Object object, Object object2) {
        Asserts.notNull((Object)object);
        Asserts.notNull((Object)object2);
        this.rangeLeft = object;
        this.rangeRight = object2;
        return this;
    }

    public SelectorBuilder setValue(Object ... objectArray) {
        CollectionUtils.nullSafeAddAll(this.setValue, (Object[])objectArray);
        return this;
    }

    public Selector build() {
        Asserts.notNull((Object)this.itemName);
        Asserts.notNull((Object)this.logicType);
        Asserts.notNull((Object)this.dataType);
        return new SelectorImpl(this.itemName, this.logicType, this.dataType, this.simpleValue, this.rangeLeft, this.rangeRight, this.setValue);
    }
}

