/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector;

import java.util.Set;
import org.springframework.lang.Nullable;
import spring.turbo.bean.Pair;
import spring.turbo.module.queryselector.DataType;
import spring.turbo.module.queryselector.Item;
import spring.turbo.module.queryselector.LogicType;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.util.Asserts;

public class SelectorImpl
implements Selector {
    private final Item item;
    private final LogicType logicType;
    private final DataType dataType;
    @Nullable
    private final Object simpleValue;
    @Nullable
    private final Object rangeLeft;
    @Nullable
    private final Object rangeRight;
    @Nullable
    private final Set<Object> set;

    public SelectorImpl(String string, LogicType logicType, DataType dataType, @Nullable Object object) {
        this(string, logicType, dataType, object, null, null, null);
    }

    public SelectorImpl(String string, LogicType logicType, DataType dataType, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Set<Object> set) {
        Asserts.notNull((Object)string);
        Asserts.notNull((Object)logicType);
        Asserts.notNull((Object)dataType);
        this.item = Item.of(string);
        this.logicType = logicType;
        this.dataType = dataType;
        this.simpleValue = object;
        this.rangeLeft = object2;
        this.rangeRight = object3;
        this.set = set;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public LogicType getLogicType() {
        return this.logicType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    @Nullable
    public <T> T getSimpleValue() {
        return (T)this.simpleValue;
    }

    @Override
    @Nullable
    public <T> Pair<T, T> getRangeValue() {
        return this.rangeLeft == null || this.rangeRight == null ? null : Pair.ofNonNull((Object)this.rangeLeft, (Object)this.rangeRight);
    }

    @Override
    @Nullable
    public <T> Set<T> getSetValue() {
        return this.set;
    }
}

