/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import spring.turbo.module.queryselector.EmptySelectorSet;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.SelectorSetImpl;
import spring.turbo.util.CollectionUtils;

public interface SelectorSet
extends Iterable<Selector>,
Serializable {
    public static SelectorSet empty() {
        return EmptySelectorSet.getInstance();
    }

    public static SelectorSet of(Selector ... selectorArray) {
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        CollectionUtils.nullSafeAddAll(arrayList, (Object[])selectorArray);
        return new SelectorSetImpl(arrayList);
    }

    public static SelectorSet of(Collection<Selector> collection) {
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        CollectionUtils.nullSafeAddAll(arrayList, collection);
        return new SelectorSetImpl(arrayList);
    }

    public List<Selector> toList();

    default public Stream<Selector> toStream() {
        return this.toList().stream();
    }

    default public int size() {
        return this.toList().size();
    }

    public boolean isEmpty();

    public String toString();
}

