/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.autoconfiguration;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import spring.turbo.module.queryselector.formatter.SelectorFormatter;
import spring.turbo.module.queryselector.formatter.SelectorSetFormatter;
import spring.turbo.module.queryselector.property.SelectorSetProperties;

@AutoConfiguration
@ConditionalOnProperty(prefix="springturbo.selector-set-formatter", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SelectorSetProperties.class})
public class QuerySetCoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SelectorFormatter selectorFormatter(SelectorSetProperties selectorSetProperties) {
        SelectorFormatter selectorFormatter = new SelectorFormatter();
        selectorFormatter.setSeparatorInSelector(selectorSetProperties.getSelectorFormatter().getSeparatorInSelector());
        selectorFormatter.setSeparatorInRange(selectorSetProperties.getSelectorFormatter().getSeparatorInRange());
        selectorFormatter.setSeparatorInSet(selectorSetProperties.getSelectorFormatter().getSeparatorInSet());
        selectorFormatter.setDatePattern(selectorSetProperties.getSelectorFormatter().getDatePattern());
        selectorFormatter.setDatetimePattern(selectorSetProperties.getSelectorFormatter().getDatetimePattern());
        return selectorFormatter;
    }

    @Bean
    @ConditionalOnMissingBean
    public SelectorSetFormatter selectorSetResolver(SelectorSetProperties selectorSetProperties, SelectorFormatter selectorFormatter) {
        SelectorSetFormatter selectorSetFormatter = new SelectorSetFormatter();
        selectorSetFormatter.setSeparatorBetweenSelectors(selectorSetProperties.getSeparatorBetweenSelectors());
        selectorSetFormatter.setIgnoreErrorIfUnableToParse(selectorSetProperties.isIgnoreErrorIfUnableToParse());
        selectorSetFormatter.setIgnoreErrorIfUnableToPrint(selectorSetProperties.isIgnoreErrorIfUnableToPrint());
        selectorSetFormatter.setSelectorFormatter(selectorFormatter);
        return selectorSetFormatter;
    }
}

