/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.formatter;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.format.Formatter;
import spring.turbo.module.queryselector.DataType;
import spring.turbo.module.queryselector.LogicType;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.SelectorImpl;
import spring.turbo.util.Asserts;
import spring.turbo.util.DateParseUtils;
import spring.turbo.util.DateUtils;
import spring.turbo.util.EnumUtils;
import spring.turbo.util.NumberParseUtils;
import spring.turbo.util.StringFormatter;
import spring.turbo.util.StringUtils;

public class SelectorFormatter
implements Formatter<Selector>,
InitializingBean {
    private String separatorInSelector = "#";
    private String separatorInRange = "<==>";
    private String separatorInSet = "'";
    private String datePattern = "yyyy-MM-dd";
    private String datetimePattern = "yyyy-MM-dd HH:mm:ss";

    public void afterPropertiesSet() {
        Asserts.hasText((String)this.separatorInSelector);
        Asserts.hasText((String)this.separatorInRange);
        Asserts.hasText((String)this.separatorInSet);
        Asserts.hasText((String)this.datePattern);
        Asserts.hasText((String)this.datetimePattern);
    }

    public Selector parse(String string, Locale locale) throws ParseException {
        Optional<Selector> optional = this.doResolveSelector(string);
        if (optional.isPresent()) {
            return optional.get();
        }
        String string2 = StringFormatter.format((String)"\"{}\" can not parsed as selector", (Object)string);
        throw new ParseException(string2, 0);
    }

    public String print(Selector selector, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(selector.getItem());
        stringBuilder.append(this.separatorInSelector);
        stringBuilder.append(selector.getLogicType());
        stringBuilder.append(this.separatorInSelector);
        stringBuilder.append(selector.getDataType());
        block0 : switch (selector.getLogicType()) {
            case IS: 
            case NOT: {
                switch (selector.getDataType()) {
                    case STRING: {
                        stringBuilder.append(selector.getSimpleValue().toString());
                        break;
                    }
                    case NUMBER: {
                        stringBuilder.append(selector.getSimpleValue().toString());
                        break;
                    }
                    case DATE: {
                        stringBuilder.append(DateUtils.format((Date)((Date)selector.getSimpleValue()), (String)this.datePattern));
                        break;
                    }
                    case DATETIME: {
                        stringBuilder.append(DateUtils.format((Date)((Date)selector.getSimpleValue()), (String)this.datetimePattern));
                    }
                }
                break;
            }
            case IN_RANGE: 
            case NOT_IN_RANGE: {
                switch (selector.getDataType()) {
                    case STRING: {
                        break;
                    }
                    case NUMBER: {
                        stringBuilder.append(selector.getRangeValue().getRequiredA());
                        stringBuilder.append(this.separatorInRange);
                        stringBuilder.append(selector.getRangeValue().getRequiredB());
                        break;
                    }
                    case DATE: {
                        stringBuilder.append(DateUtils.format((Date)((Date)selector.getRangeValue().getRequiredA()), (String)this.datePattern));
                        stringBuilder.append(this.separatorInRange);
                        stringBuilder.append(DateUtils.format((Date)((Date)selector.getRangeValue().getRequiredB()), (String)this.datePattern));
                        break;
                    }
                    case DATETIME: {
                        stringBuilder.append(DateUtils.format((Date)((Date)selector.getRangeValue().getRequiredA()), (String)this.datetimePattern));
                        stringBuilder.append(this.separatorInRange);
                        stringBuilder.append(DateUtils.format((Date)((Date)selector.getRangeValue().getRequiredB()), (String)this.datetimePattern));
                    }
                }
                break;
            }
            case IN_SET: 
            case NOT_IN_SET: {
                switch (selector.getDataType()) {
                    case STRING: {
                        stringBuilder.append(StringUtils.nullSafeJoin(selector.getSetValue(), (String)this.separatorInSet));
                        break block0;
                    }
                    case NUMBER: {
                        stringBuilder.append(StringUtils.nullSafeJoin(selector.getSetValue(), (String)this.separatorInSet));
                        break block0;
                    }
                    case DATE: {
                        Set set = selector.getSetValue().stream().map(object -> DateUtils.format((Date)((Date)object), (String)this.datePattern)).collect(Collectors.toSet());
                        stringBuilder.append(StringUtils.nullSafeJoin(set, (String)this.separatorInSet));
                        break block0;
                    }
                    case DATETIME: {
                        Set set = selector.getSetValue().stream().map(object -> DateUtils.format((Date)((Date)object), (String)this.datetimePattern)).collect(Collectors.toSet());
                        stringBuilder.append(StringUtils.nullSafeJoin(set, (String)this.separatorInSet));
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    private Optional<Selector> doResolveSelector(String string2) {
        String[] stringArray = string2.split(this.separatorInSelector);
        String string3 = stringArray[0];
        if (StringUtils.isBlank((String)string3)) {
            return Optional.empty();
        }
        LogicType logicType = (LogicType)EnumUtils.getEnumIgnoreCase(LogicType.class, (String)stringArray[1]);
        if (logicType == null) {
            return Optional.empty();
        }
        DataType dataType = (DataType)EnumUtils.getEnumIgnoreCase(DataType.class, (String)stringArray[2]);
        if (dataType == null) {
            return Optional.empty();
        }
        String string4 = stringArray[3];
        if (StringUtils.isBlank((String)string4)) {
            return Optional.empty();
        }
        switch (logicType) {
            case IS: 
            case NOT: {
                switch (dataType) {
                    case STRING: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, string4));
                    }
                    case NUMBER: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, NumberParseUtils.parse((String)string4, BigDecimal.class)));
                    }
                    case DATE: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, DateParseUtils.parse((String)string4, (String)this.datePattern, (String[])new String[0])));
                    }
                    case DATETIME: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, DateParseUtils.parse((String)string4, (String)this.datetimePattern, (String[])new String[0])));
                    }
                }
            }
            case IN_RANGE: 
            case NOT_IN_RANGE: {
                String[] stringArray2 = string4.split(this.separatorInRange);
                if (stringArray2.length != 2) break;
                String string5 = stringArray2[0];
                String string6 = stringArray2[1];
                switch (dataType) {
                    case STRING: {
                        break;
                    }
                    case NUMBER: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, NumberParseUtils.parse((String)string5, BigDecimal.class), NumberParseUtils.parse((String)string6, BigDecimal.class), null));
                    }
                    case DATE: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, DateParseUtils.parse((String)string5, (String)this.datePattern, (String[])new String[0]), DateParseUtils.parse((String)string6, (String)this.datePattern, (String[])new String[0]), null));
                    }
                    case DATETIME: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, DateParseUtils.parse((String)string5, (String)this.datetimePattern, (String[])new String[0]), DateParseUtils.parse((String)string6, (String)this.datetimePattern, (String[])new String[0]), null));
                    }
                }
            }
            case IN_SET: 
            case NOT_IN_SET: {
                String[] stringArray3 = string4.split(this.separatorInSet);
                switch (dataType) {
                    case STRING: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, null, null, Stream.of(stringArray3).collect(Collectors.toSet())));
                    }
                    case NUMBER: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, null, null, Stream.of(stringArray3).map(string -> (BigDecimal)NumberParseUtils.parse((String)string, BigDecimal.class)).collect(Collectors.toSet())));
                    }
                    case DATE: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, null, null, Stream.of(stringArray3).map(string -> DateParseUtils.parse((String)string, (String)this.datePattern, (String[])new String[0])).collect(Collectors.toSet())));
                    }
                    case DATETIME: {
                        return Optional.of(new SelectorImpl(string3, logicType, dataType, null, null, null, Stream.of(stringArray3).map(string -> DateParseUtils.parse((String)string, (String)this.datetimePattern, (String[])new String[0])).collect(Collectors.toSet())));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public void setSeparatorInSelector(String string) {
        this.separatorInSelector = string;
    }

    public void setSeparatorInRange(String string) {
        this.separatorInRange = string;
    }

    public void setSeparatorInSet(String string) {
        this.separatorInSet = string;
    }

    public void setDatePattern(String string) {
        this.datePattern = string;
    }

    public void setDatetimePattern(String string) {
        this.datetimePattern = string;
    }
}

