/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.formatter;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.format.Formatter;
import org.springframework.lang.Nullable;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.SelectorSet;
import spring.turbo.module.queryselector.SelectorSetImpl;
import spring.turbo.module.queryselector.formatter.SelectorFormatter;
import spring.turbo.util.Asserts;
import spring.turbo.util.StringUtils;

public class SelectorSetFormatter
implements Formatter<SelectorSet>,
InitializingBean {
    private String separatorBetweenSelectors = "@@";
    private boolean ignoreErrorIfUnableToParse = false;
    private boolean ignoreErrorIfUnableToPrint = false;
    @Nullable
    private SelectorFormatter selectorFormatter;

    public SelectorSet parse(String string, Locale locale) throws ParseException {
        Asserts.notNull((Object)this.selectorFormatter);
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        for (String string2 : string.split(this.separatorBetweenSelectors)) {
            try {
                Selector selector = this.selectorFormatter.parse(string2, locale);
                arrayList.add(selector);
            }
            catch (ParseException parseException) {
                if (this.ignoreErrorIfUnableToParse) continue;
                throw parseException;
            }
        }
        return new SelectorSetImpl(arrayList);
    }

    public String print(SelectorSet selectorSet, Locale locale) {
        Asserts.notNull((Object)this.selectorFormatter);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Selector selector : selectorSet) {
            try {
                arrayList.add(this.selectorFormatter.print(selector, locale));
            }
            catch (Exception exception) {
                if (this.ignoreErrorIfUnableToPrint) continue;
                throw exception;
            }
        }
        return StringUtils.nullSafeJoin(arrayList, (String)this.separatorBetweenSelectors);
    }

    public void afterPropertiesSet() {
        Asserts.hasText((String)this.separatorBetweenSelectors);
        Asserts.notNull((Object)this.selectorFormatter);
    }

    public void setSeparatorBetweenSelectors(String string) {
        this.separatorBetweenSelectors = string;
    }

    public void setSelectorFormatter(SelectorFormatter selectorFormatter) {
        this.selectorFormatter = selectorFormatter;
    }

    public void setIgnoreErrorIfUnableToParse(boolean bl) {
        this.ignoreErrorIfUnableToParse = bl;
    }

    public void setIgnoreErrorIfUnableToPrint(boolean bl) {
        this.ignoreErrorIfUnableToPrint = bl;
    }
}

