/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.jsr380;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.springframework.lang.Nullable;
import spring.turbo.module.queryselector.DataType;
import spring.turbo.module.queryselector.LogicType;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.SelectorSet;
import spring.turbo.module.queryselector.jsr380.DecentSelectorSet;
import spring.turbo.util.Asserts;

public class DecentSelectorSetValidator
implements ConstraintValidator<DecentSelectorSet, SelectorSet> {
    @Nullable
    private DecentSelectorSet annotation;

    public void initialize(DecentSelectorSet decentSelectorSet) {
        this.annotation = decentSelectorSet;
    }

    public boolean isValid(@Nullable SelectorSet selectorSet, ConstraintValidatorContext constraintValidatorContext) {
        Asserts.notNull((Object)this.annotation);
        if (selectorSet == null) {
            return true;
        }
        int n = selectorSet.size();
        if (n < this.annotation.min() || n > this.annotation.max()) {
            return false;
        }
        for (Selector selector : selectorSet) {
            if (selector.getLogicType() != LogicType.IN_RANGE && selector.getLogicType() != LogicType.IN_SET || selector.getDataType() != DataType.STRING) continue;
            return false;
        }
        return false;
    }
}

