/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.property;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="springturbo.selector-set-formatter")
public class SelectorSetProperties {
    private boolean enabled = true;
    private String separatorBetweenSelectors = "@@";
    private SelectorProperties selectorFormatter = new SelectorProperties();
    private boolean ignoreErrorIfUnableToParse = false;
    private boolean ignoreErrorIfUnableToPrint = false;
    private SQL sql = new SQL();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSeparatorBetweenSelectors() {
        return this.separatorBetweenSelectors;
    }

    public SelectorProperties getSelectorFormatter() {
        return this.selectorFormatter;
    }

    public boolean isIgnoreErrorIfUnableToParse() {
        return this.ignoreErrorIfUnableToParse;
    }

    public boolean isIgnoreErrorIfUnableToPrint() {
        return this.ignoreErrorIfUnableToPrint;
    }

    public SQL getSql() {
        return this.sql;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setSeparatorBetweenSelectors(String string) {
        this.separatorBetweenSelectors = string;
    }

    public void setSelectorFormatter(SelectorProperties selectorProperties) {
        this.selectorFormatter = selectorProperties;
    }

    public void setIgnoreErrorIfUnableToParse(boolean bl) {
        this.ignoreErrorIfUnableToParse = bl;
    }

    public void setIgnoreErrorIfUnableToPrint(boolean bl) {
        this.ignoreErrorIfUnableToPrint = bl;
    }

    public void setSql(SQL sQL) {
        this.sql = sQL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelectorSetProperties)) {
            return false;
        }
        SelectorSetProperties selectorSetProperties = (SelectorSetProperties)object;
        if (!selectorSetProperties.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != selectorSetProperties.isEnabled()) {
            return false;
        }
        if (this.isIgnoreErrorIfUnableToParse() != selectorSetProperties.isIgnoreErrorIfUnableToParse()) {
            return false;
        }
        if (this.isIgnoreErrorIfUnableToPrint() != selectorSetProperties.isIgnoreErrorIfUnableToPrint()) {
            return false;
        }
        String string = this.getSeparatorBetweenSelectors();
        String string2 = selectorSetProperties.getSeparatorBetweenSelectors();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        SelectorProperties selectorProperties = this.getSelectorFormatter();
        SelectorProperties selectorProperties2 = selectorSetProperties.getSelectorFormatter();
        if (selectorProperties == null ? selectorProperties2 != null : !((Object)selectorProperties).equals(selectorProperties2)) {
            return false;
        }
        SQL sQL = this.getSql();
        SQL sQL2 = selectorSetProperties.getSql();
        return !(sQL == null ? sQL2 != null : !((Object)sQL).equals(sQL2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SelectorSetProperties;
    }

    public int hashCode() {
        int n = 1;
        n = n * 59 + (this.isEnabled() ? 79 : 97);
        n = n * 59 + (this.isIgnoreErrorIfUnableToParse() ? 79 : 97);
        n = n * 59 + (this.isIgnoreErrorIfUnableToPrint() ? 79 : 97);
        String string = this.getSeparatorBetweenSelectors();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        SelectorProperties selectorProperties = this.getSelectorFormatter();
        n = n * 59 + (selectorProperties == null ? 43 : ((Object)selectorProperties).hashCode());
        SQL sQL = this.getSql();
        n = n * 59 + (sQL == null ? 43 : ((Object)sQL).hashCode());
        return n;
    }

    public String toString() {
        return "SelectorSetProperties(enabled=" + this.isEnabled() + ", separatorBetweenSelectors=" + this.getSeparatorBetweenSelectors() + ", selectorFormatter=" + this.getSelectorFormatter() + ", ignoreErrorIfUnableToParse=" + this.isIgnoreErrorIfUnableToParse() + ", ignoreErrorIfUnableToPrint=" + this.isIgnoreErrorIfUnableToPrint() + ", sql=" + this.getSql() + ")";
    }

    public static class SelectorProperties {
        private String separatorInSelector = "#";
        private String separatorInRange = "<==>";
        private String separatorInSet = "'";
        private String datePattern = "yyyy-MM-dd";
        private String datetimePattern = "yyyy-MM-dd HH:mm:ss";

        public String getSeparatorInSelector() {
            return this.separatorInSelector;
        }

        public String getSeparatorInRange() {
            return this.separatorInRange;
        }

        public String getSeparatorInSet() {
            return this.separatorInSet;
        }

        public String getDatePattern() {
            return this.datePattern;
        }

        public String getDatetimePattern() {
            return this.datetimePattern;
        }

        public void setSeparatorInSelector(String string) {
            this.separatorInSelector = string;
        }

        public void setSeparatorInRange(String string) {
            this.separatorInRange = string;
        }

        public void setSeparatorInSet(String string) {
            this.separatorInSet = string;
        }

        public void setDatePattern(String string) {
            this.datePattern = string;
        }

        public void setDatetimePattern(String string) {
            this.datetimePattern = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SelectorProperties)) {
                return false;
            }
            SelectorProperties selectorProperties = (SelectorProperties)object;
            if (!selectorProperties.canEqual(this)) {
                return false;
            }
            String string = this.getSeparatorInSelector();
            String string2 = selectorProperties.getSeparatorInSelector();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getSeparatorInRange();
            String string4 = selectorProperties.getSeparatorInRange();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            String string5 = this.getSeparatorInSet();
            String string6 = selectorProperties.getSeparatorInSet();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                return false;
            }
            String string7 = this.getDatePattern();
            String string8 = selectorProperties.getDatePattern();
            if (string7 == null ? string8 != null : !string7.equals(string8)) {
                return false;
            }
            String string9 = this.getDatetimePattern();
            String string10 = selectorProperties.getDatetimePattern();
            return !(string9 == null ? string10 != null : !string9.equals(string10));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SelectorProperties;
        }

        public int hashCode() {
            int n = 1;
            String string = this.getSeparatorInSelector();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getSeparatorInRange();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            String string3 = this.getSeparatorInSet();
            n = n * 59 + (string3 == null ? 43 : string3.hashCode());
            String string4 = this.getDatePattern();
            n = n * 59 + (string4 == null ? 43 : string4.hashCode());
            String string5 = this.getDatetimePattern();
            n = n * 59 + (string5 == null ? 43 : string5.hashCode());
            return n;
        }

        public String toString() {
            return "SelectorSetProperties.SelectorProperties(separatorInSelector=" + this.getSeparatorInSelector() + ", separatorInRange=" + this.getSeparatorInRange() + ", separatorInSet=" + this.getSeparatorInSet() + ", datePattern=" + this.getDatePattern() + ", datetimePattern=" + this.getDatetimePattern() + ")";
        }
    }

    public static class SQL {
        private boolean enabled = true;
        private Map<String, String> itemNameToTableColumnMappings = new HashMap<String, String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public Map<String, String> getItemNameToTableColumnMappings() {
            return this.itemNameToTableColumnMappings;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setItemNameToTableColumnMappings(Map<String, String> map) {
            this.itemNameToTableColumnMappings = map;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SQL)) {
                return false;
            }
            SQL sQL = (SQL)object;
            if (!sQL.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != sQL.isEnabled()) {
                return false;
            }
            Map<String, String> map = this.getItemNameToTableColumnMappings();
            Map<String, String> map2 = sQL.getItemNameToTableColumnMappings();
            return !(map == null ? map2 != null : !((Object)map).equals(map2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SQL;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isEnabled() ? 79 : 97);
            Map<String, String> map = this.getItemNameToTableColumnMappings();
            n = n * 59 + (map == null ? 43 : ((Object)map).hashCode());
            return n;
        }

        public String toString() {
            return "SelectorSetProperties.SQL(enabled=" + this.isEnabled() + ", itemNameToTableColumnMappings=" + this.getItemNameToTableColumnMappings() + ")";
        }
    }
}

