/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.sql;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.Nullable;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.SelectorSet;
import spring.turbo.module.queryselector.sql.WhereClauseBuilder;
import spring.turbo.module.queryselector.sql.exception.SQLBuildingException;
import spring.turbo.util.ClassPathDirUtils;
import spring.turbo.util.collection.StringObjectMap;

public class WhereClauseBuilderImpl
implements WhereClauseBuilder {
    private static final Class<WhereClauseBuilderImpl> THIS_TYPE = WhereClauseBuilderImpl.class;
    private static final String TEMPLATE_NAME = THIS_TYPE.getSimpleName() + ".ftl";
    private static final String TEMPLATE_CLASS_PATH = ClassPathDirUtils.getClassPathDir(THIS_TYPE);
    private final Map<String, String> itemNameToTableColumnMappings;
    private final Configuration freemarkerConfiguration = this.createFreemarkerConfiguration();

    public WhereClauseBuilderImpl() {
        this(null);
    }

    public WhereClauseBuilderImpl(@Nullable Map<String, String> map) {
        this.itemNameToTableColumnMappings = Objects.requireNonNullElse(map, Collections.emptyMap());
    }

    private Configuration createFreemarkerConfiguration() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);
        configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(THIS_TYPE, TEMPLATE_CLASS_PATH));
        configuration.setAPIBuiltinEnabled(true);
        configuration.setCacheStorage((CacheStorage)NullCacheStorage.INSTANCE);
        return configuration;
    }

    @Override
    public String apply(@Nullable SelectorSet selectorSet, Map<String, String> map) {
        if (selectorSet == null || selectorSet.isEmpty()) {
            return " (1 = 1) ";
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll(this.createItemNameMap(selectorSet));
            hashMap.putAll(this.itemNameToTableColumnMappings);
            hashMap.putAll(map);
            StringObjectMap stringObjectMap = StringObjectMap.newInstance().add("itemNameToTableColumnMap", Collections.unmodifiableMap(hashMap)).add("selectorList", selectorSet.toList());
            StringWriter stringWriter = new StringWriter();
            Template template = this.freemarkerConfiguration.getTemplate(TEMPLATE_NAME);
            template.process((Object)stringObjectMap, (Writer)stringWriter);
            return this.formatSql(stringWriter.toString());
        }
        catch (Exception exception) {
            throw new SQLBuildingException(exception.getMessage(), exception);
        }
    }

    private String formatSql(String string) {
        return string.replaceAll("\n", "").replaceAll("[ ]+", " ");
    }

    private Map<String, String> createItemNameMap(SelectorSet selectorSet) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Selector selector : selectorSet) {
            hashMap.put(selector.getItem().getName(), selector.getItem().getName());
        }
        return hashMap;
    }
}

