/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.queryselector.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import spring.turbo.bean.Pair;
import spring.turbo.module.queryselector.DataType;
import spring.turbo.module.queryselector.Selector;
import spring.turbo.module.queryselector.exception.SelectorValueFindingException;
import spring.turbo.util.BigDecimalUtils;

public final class SelectorUtils {
    private SelectorUtils() {
    }

    public static <T> T getSimpleValueAndConvert(Selector selector, Class<T> clazz) {
        Object t = selector.getSimpleValue();
        return SelectorUtils.doConvert(t, selector.getDataType(), clazz);
    }

    public static <T> Set<T> getValueSetAndConvert(Selector selector, Class<T> clazz) {
        Set set = selector.getSetValue();
        if (set == null) {
            throw new SelectorValueFindingException("Cannot get simple value");
        }
        HashSet<T> hashSet = new HashSet<T>();
        for (Object t : set) {
            hashSet.add(SelectorUtils.doConvert(t, selector.getDataType(), clazz));
        }
        return hashSet;
    }

    public static <T> Pair<T, T> getValueRangeAndConvert(Selector selector, Class<T> clazz) {
        Pair pair = selector.getRangeValue();
        if (pair == null) {
            throw new SelectorValueFindingException("Cannot get simple value");
        }
        return Pair.ofNonNull(SelectorUtils.doConvert(pair.getRequiredA(), selector.getDataType(), clazz), SelectorUtils.doConvert(pair.getRequiredB(), selector.getDataType(), clazz));
    }

    private static <T> T doConvert(@Nullable Object object, DataType dataType, Class<?> clazz) {
        if (object == null) {
            throw new SelectorValueFindingException("Cannot get simple value");
        }
        if (dataType == DataType.STRING && clazz == String.class) {
            return (T)object;
        }
        if (dataType == DataType.NUMBER) {
            if (clazz == Byte.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), Byte.class);
            }
            if (clazz == Short.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), Short.class);
            }
            if (clazz == Integer.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), Integer.class);
            }
            if (clazz == Long.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), Long.class);
            }
            if (clazz == Float.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), Float.class);
            }
            if (clazz == Double.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), Double.class);
            }
            if (clazz == BigInteger.class) {
                return (T)BigDecimalUtils.getValue((BigDecimal)((BigDecimal)object), BigInteger.class);
            }
            if (clazz == BigDecimal.class) {
                return (T)object;
            }
        }
        if ((dataType == DataType.DATE || dataType == DataType.DATETIME) && clazz == Date.class) {
            return (T)object;
        }
        throw new SelectorValueFindingException("Cannot get simple value");
    }
}

