/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.redis.util;

import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import spring.turbo.core.SpringUtils;
import spring.turbo.module.redis.util.LockKeyFunction;
import spring.turbo.util.Asserts;

public final class LockUtils {
    private static final List<String> EMPTY_KEYS = Collections.emptyList();
    private static final LockKeyFunction DEFAULT_LOCK_KEY_FUNC = string -> string;

    private LockUtils() {
    }

    public static boolean lock(String string, String string2, int n) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        Asserts.isTrue((n >= 1 ? 1 : 0) != 0);
        LockKeyFunction lockKeyFunction = SpringUtils.getBean(LockKeyFunction.class).orElse(DEFAULT_LOCK_KEY_FUNC);
        string = lockKeyFunction.apply(string);
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtils.getRequiredBean(StringRedisTemplate.class);
        RedisScript redisScript = (RedisScript)SpringUtils.getRequiredBean(RedisScript.class, (String)"redisLockLockLuaScript");
        Boolean bl = (Boolean)stringRedisTemplate.execute(redisScript, EMPTY_KEYS, new Object[]{string, string2, String.valueOf(n)});
        return bl != null ? bl : false;
    }

    public static boolean release(String string, String string2) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        LockKeyFunction lockKeyFunction = SpringUtils.getBean(LockKeyFunction.class).orElse(DEFAULT_LOCK_KEY_FUNC);
        string = lockKeyFunction.apply(string);
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtils.getRequiredBean(StringRedisTemplate.class);
        RedisScript redisScript = (RedisScript)SpringUtils.getRequiredBean(RedisScript.class, (String)"redisLockReleaseLuaScript");
        Boolean bl = (Boolean)stringRedisTemplate.execute(redisScript, EMPTY_KEYS, new Object[]{string, string2});
        return bl != null ? bl : false;
    }
}

