/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import java.util.Optional;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import spring.turbo.module.security.authentication.TokenToUserConverter;
import spring.turbo.module.security.jwt.AlgorithmFactory;
import spring.turbo.util.Asserts;
import spring.turbo.webmvc.token.StringToken;
import spring.turbo.webmvc.token.Token;

public abstract class AbstractJwtTokenToUserConverter
implements TokenToUserConverter {
    private final Algorithm algorithm;

    public AbstractJwtTokenToUserConverter(AlgorithmFactory algorithmFactory) {
        Asserts.notNull((Object)algorithmFactory);
        Algorithm algorithm = (Algorithm)algorithmFactory.create();
        Asserts.notNull((Object)algorithm);
        this.algorithm = algorithm;
    }

    public AbstractJwtTokenToUserConverter(Algorithm algorithm) {
        Asserts.notNull((Object)algorithm);
        this.algorithm = algorithm;
    }

    public final UserDetails convert(Token token) throws AuthenticationException {
        if (!(token instanceof StringToken)) {
            return null;
        }
        try {
            String string = ((StringToken)token).getContent();
            Verification verification = JWT.require((Algorithm)this.algorithm);
            JWTVerifier jWTVerifier = verification.build();
            DecodedJWT decodedJWT = jWTVerifier.verify(string);
            return this.doAuthenticate(string, decodedJWT).orElse(null);
        }
        catch (JWTVerificationException jWTVerificationException) {
            throw new BadCredentialsException(jWTVerificationException.getMessage(), (Throwable)jWTVerificationException);
        }
    }

    protected abstract Optional<UserDetails> doAuthenticate(String var1, DecodedJWT var2) throws AuthenticationException;
}

