/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import com.auth0.jwt.algorithms.Algorithm;
import java.util.UUID;
import spring.turbo.module.security.jwt.AlgorithmFactory;
import spring.turbo.module.security.jwt.ECDSA256AlgorithmFactory;
import spring.turbo.module.security.jwt.ECDSA256KAlgorithmFactory;
import spring.turbo.module.security.jwt.ECDSA384AlgorithmFactory;
import spring.turbo.module.security.jwt.ECDSA512AlgorithmFactory;
import spring.turbo.module.security.jwt.RSA256AlgorithmFactory;
import spring.turbo.module.security.jwt.RSA384AlgorithmFactory;
import spring.turbo.module.security.jwt.RSA512AlgorithmFactory;

public final class AlgorithmFactoryFactories {
    private AlgorithmFactoryFactories() {
    }

    public static AlgorithmFactory none() {
        return Algorithm::none;
    }

    public static AlgorithmFactory random() {
        return () -> Algorithm.HMAC384((String)UUID.randomUUID().toString());
    }

    public static AlgorithmFactory hmac256(String string) {
        return () -> Algorithm.HMAC256((String)string);
    }

    public static AlgorithmFactory hmac384(String string) {
        return () -> Algorithm.HMAC384((String)string);
    }

    public static AlgorithmFactory hmac512(String string) {
        return () -> Algorithm.HMAC512((String)string);
    }

    public static AlgorithmFactory rsa256(String string, String string2) {
        return new RSA256AlgorithmFactory(string, string2);
    }

    public static AlgorithmFactory rsa384(String string, String string2) {
        return new RSA384AlgorithmFactory(string, string2);
    }

    public static AlgorithmFactory rsa512(String string, String string2) {
        return new RSA512AlgorithmFactory(string, string2);
    }

    public static AlgorithmFactory ecdsa256(String string, String string2) {
        return new ECDSA256AlgorithmFactory(string, string2);
    }

    public static AlgorithmFactory ecdsa256k(String string, String string2) {
        return new ECDSA256KAlgorithmFactory(string, string2);
    }

    public static AlgorithmFactory ecdsa384(String string, String string2) {
        return new ECDSA384AlgorithmFactory(string, string2);
    }

    public static AlgorithmFactory ecdsa512(String string, String string2) {
        return new ECDSA512AlgorithmFactory(string, string2);
    }
}

