/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import spring.turbo.module.security.jwt.AlgorithmFactory;
import spring.turbo.module.security.jwt.JwtTokenFactory;
import spring.turbo.module.security.jwt.JwtTokenMetadata;
import spring.turbo.util.Asserts;

class JwtTokenFactoryImpl
implements JwtTokenFactory {
    private final Algorithm algorithm;

    public JwtTokenFactoryImpl(AlgorithmFactory algorithmFactory) {
        Asserts.notNull((Object)algorithmFactory);
        Algorithm algorithm = (Algorithm)algorithmFactory.create();
        Asserts.notNull((Object)algorithm);
        this.algorithm = algorithm;
    }

    @Override
    public String create(JwtTokenMetadata jwtTokenMetadata) {
        JWTCreator.Builder builder = JWT.create();
        Optional.ofNullable(jwtTokenMetadata.getKeyId()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withKeyId(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getJwtId()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withJWTId(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getIssuer()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withIssuer(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getSubject()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withSubject(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getExpiresAt()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withExpiresAt(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getNotBefore()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withNotBefore(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getIssuedAt()).ifPresent(arg_0 -> ((JWTCreator.Builder)builder).withIssuedAt(arg_0));
        Optional.ofNullable(jwtTokenMetadata.getAudience()).ifPresent(list -> {
            if (!list.isEmpty()) {
                builder.withAudience(jwtTokenMetadata.getAudience().toArray(new String[0]));
            }
        });
        Optional.ofNullable(jwtTokenMetadata.getPayloadClaims()).ifPresent(payload -> {
            Set set = payload.keySet();
            for (String string : set) {
                Object object = payload.get((Object)string);
                if (object instanceof String) {
                    builder.withClaim(string, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    builder.withClaim(string, (Integer)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    builder.withClaim(string, (Boolean)object);
                    continue;
                }
                if (object instanceof Date) {
                    builder.withClaim(string, (Date)object);
                    continue;
                }
                if (object instanceof Long) {
                    builder.withClaim(string, (Long)object);
                    continue;
                }
                if (object instanceof Double) {
                    builder.withClaim(string, (Double)object);
                    continue;
                }
                if (object instanceof String[]) {
                    builder.withArrayClaim(string, (String[])object);
                    continue;
                }
                if (object instanceof Integer[]) {
                    builder.withArrayClaim(string, (Integer[])object);
                    continue;
                }
                if (!(object instanceof Long[])) continue;
                builder.withArrayClaim(string, (Long[])object);
            }
        });
        return builder.sign(this.algorithm);
    }
}

