/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import spring.turbo.module.security.jwt.AlgorithmFactory;
import spring.turbo.util.crypto.Base64;

abstract class RSAAlgorithmFactory
implements AlgorithmFactory {
    private static final String RSA = "RSA";

    RSAAlgorithmFactory() {
    }

    private byte[] decryptBase64(String string) {
        return Base64.toBytes((String)string);
    }

    protected RSAPublicKey toPublicKey(String string) {
        try {
            byte[] byArray = this.decryptBase64(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            return (RSAPublicKey)publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException.getMessage(), invalidKeySpecException);
        }
    }

    protected RSAPrivateKey toPrivateKey(String string) {
        try {
            byte[] byArray = this.decryptBase64(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return (RSAPrivateKey)privateKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException.getMessage(), invalidKeySpecException);
        }
    }
}

