/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import spring.turbo.bean.Payload;

public final class JwtTokenMetadata
implements Serializable {
    @Nullable
    private String keyId;
    @Nullable
    private String issuer;
    @Nullable
    private String subject;
    private List<String> audience = new ArrayList<String>();
    @Nullable
    private Date expiresAt;
    @Nullable
    private Date notBefore;
    @Nullable
    private Date issuedAt;
    @Nullable
    private String jwtId;
    private Payload payloadClaims = Payload.newInstance();

    private JwtTokenMetadata() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String string) {
        this.issuer = string;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(List<String> list) {
        this.audience = list;
    }

    @Nullable
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date date) {
        this.expiresAt = date;
    }

    @Nullable
    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date date) {
        this.notBefore = date;
    }

    @Nullable
    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(Date date) {
        this.issuedAt = date;
    }

    @Nullable
    public String getJwtId() {
        return this.jwtId;
    }

    public void setJwtId(String string) {
        this.jwtId = string;
    }

    public Payload getPayloadClaims() {
        return this.payloadClaims;
    }

    public void setPayloadClaims(Payload payload) {
        this.payloadClaims = payload;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JwtTokenMetadata jwtTokenMetadata = (JwtTokenMetadata)object;
        return Objects.equals(this.keyId, jwtTokenMetadata.keyId) && Objects.equals(this.issuer, jwtTokenMetadata.issuer) && Objects.equals(this.subject, jwtTokenMetadata.subject) && Objects.equals(this.audience, jwtTokenMetadata.audience) && Objects.equals(this.expiresAt, jwtTokenMetadata.expiresAt) && Objects.equals(this.notBefore, jwtTokenMetadata.notBefore) && Objects.equals(this.issuedAt, jwtTokenMetadata.issuedAt) && Objects.equals(this.jwtId, jwtTokenMetadata.jwtId) && Objects.equals(this.payloadClaims, jwtTokenMetadata.payloadClaims);
    }

    public int hashCode() {
        return Objects.hash(this.keyId, this.issuer, this.subject, this.audience, this.expiresAt, this.notBefore, this.issuedAt, this.jwtId, this.payloadClaims);
    }

    public static class Builder
    implements spring.turbo.bean.Builder<JwtTokenMetadata> {
        private final Payload payloadClaims = Payload.newInstance();
        private String keyId;
        private String issuer;
        private String subject;
        private List<String> audience = new ArrayList<String>();
        private Date expiresAt;
        private Date notBefore;
        private Date issuedAt;
        private String jwtId;

        private Builder() {
        }

        public Builder keyId(String string) {
            this.keyId = string;
            return this;
        }

        public Builder keyId(Supplier<String> supplier) {
            return this.keyId(supplier.get());
        }

        public Builder issuer(String string) {
            this.issuer = string;
            return this;
        }

        public Builder subject(String string) {
            this.subject = string;
            return this;
        }

        public Builder audience(List<String> list) {
            this.audience = list;
            return this;
        }

        public Builder audience(String ... stringArray) {
            return this.audience(Arrays.asList(stringArray));
        }

        public Builder expiresAt(Date date) {
            this.expiresAt = date;
            return this;
        }

        public Builder expiresAtFuture(long l, TimeUnit timeUnit) {
            return this.expiresAt(this.afterNow(l, timeUnit));
        }

        public Builder expiresAtFuture(Duration duration) {
            return this.expiresAtFuture(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        public Builder notBefore(Date date) {
            this.notBefore = date;
            return this;
        }

        public Builder notBeforeFuture(long l, TimeUnit timeUnit) {
            return this.notBefore(this.afterNow(l, timeUnit));
        }

        public Builder notBeforeFuture(Duration duration) {
            return this.notBeforeFuture(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        public Builder issuedAt(Date date) {
            this.issuedAt = date;
            return this;
        }

        public Builder issuedAtNow() {
            return this.issuedAt(new Date());
        }

        public Builder jwtId(String string) {
            this.jwtId = string;
            return this;
        }

        public Builder jwtId(Supplier<String> supplier) {
            return this.jwtId(supplier.get());
        }

        public Builder putPayloadClaim(String string, Boolean bl) {
            return this.doPutPayloadClaim(string, bl);
        }

        public Builder putPayloadClaim(String string, Date date) {
            return this.doPutPayloadClaim(string, date);
        }

        public Builder putPayloadClaim(String string, Double d) {
            return this.doPutPayloadClaim(string, d);
        }

        public Builder putPayloadClaim(String string, String string2) {
            return this.doPutPayloadClaim(string, string2);
        }

        public Builder putPayloadClaim(String string, String[] stringArray) {
            return this.doPutPayloadClaim(string, stringArray);
        }

        public Builder putPayloadClaim(String string, Integer n) {
            return this.doPutPayloadClaim(string, n);
        }

        public Builder putPayloadClaim(String string, Integer[] integerArray) {
            return this.doPutPayloadClaim(string, integerArray);
        }

        public Builder putPayloadClaim(String string, Long l) {
            return this.doPutPayloadClaim(string, l);
        }

        public Builder putPayloadClaim(String string, Long[] longArray) {
            return this.doPutPayloadClaim(string, longArray);
        }

        private Builder doPutPayloadClaim(String string, Object object) {
            Objects.requireNonNull(string);
            Objects.requireNonNull(object);
            this.payloadClaims.put((Object)string, object);
            return this;
        }

        public JwtTokenMetadata build() {
            JwtTokenMetadata jwtTokenMetadata = new JwtTokenMetadata();
            jwtTokenMetadata.jwtId = this.jwtId;
            jwtTokenMetadata.keyId = this.keyId;
            jwtTokenMetadata.issuer = this.issuer;
            jwtTokenMetadata.subject = this.subject;
            jwtTokenMetadata.audience = this.audience;
            jwtTokenMetadata.expiresAt = this.expiresAt;
            jwtTokenMetadata.notBefore = this.notBefore;
            jwtTokenMetadata.issuedAt = this.issuedAt;
            jwtTokenMetadata.payloadClaims = this.payloadClaims;
            return jwtTokenMetadata;
        }

        private Date afterNow(long l, TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit);
            return new Date(System.currentTimeMillis() + timeUnit.toMillis(l));
        }
    }
}

