/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.AuthenticationException;
import spring.turbo.module.security.exception.MaliciousRequestException;

final class VerificationExceptionTransformer {
    private VerificationExceptionTransformer() {
    }

    public static AuthenticationException transform(JWTVerificationException jWTVerificationException) {
        if (jWTVerificationException instanceof TokenExpiredException) {
            return new CredentialsExpiredException(jWTVerificationException.getMessage());
        }
        if (jWTVerificationException instanceof AlgorithmMismatchException) {
            throw new MaliciousRequestException(jWTVerificationException.getMessage());
        }
        if (jWTVerificationException instanceof SignatureVerificationException) {
            throw new MaliciousRequestException(jWTVerificationException.getMessage());
        }
        return new BadCredentialsException(jWTVerificationException.getMessage());
    }
}

