/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.webmvc.util;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import spring.turbo.util.Asserts;

public final class ServletUtils {
    private ServletUtils() {
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletRequest getRequiredRequest() {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        Asserts.notNull((Object)httpServletRequest);
        return httpServletRequest;
    }

    public static HttpServletRequest getUnwrappedRequest() {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        while (httpServletRequest instanceof HttpServletRequestWrapper) {
            httpServletRequest = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest).getRequest();
        }
        return httpServletRequest;
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return servletRequestAttributes.getResponse();
    }

    public static HttpServletResponse getRequiredResponse() {
        HttpServletResponse httpServletResponse = ServletUtils.getResponse();
        Asserts.notNull((Object)httpServletResponse);
        return httpServletResponse;
    }

    @Nullable
    public static HttpServletResponse getUnwrappedResponse() {
        HttpServletResponse httpServletResponse = ServletUtils.getResponse();
        while (httpServletResponse instanceof HttpServletResponseWrapper) {
            httpServletResponse = (HttpServletResponse)((HttpServletResponseWrapper)httpServletResponse).getResponse();
        }
        return httpServletResponse;
    }

    public static HttpSession getSession() {
        return ServletUtils.getSession(true);
    }

    public static HttpSession getSession(boolean bl) {
        return ServletUtils.getRequest().getSession(bl);
    }

    public static String getSessionId() {
        return ServletUtils.getSession().getId();
    }

    public static ServletContext getServletContext() {
        return ServletUtils.getRequest().getServletContext();
    }
}

