/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.autoconfiguration;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import spring.turbo.module.webmvc.autoconfiguration.SpringBootWebMvcProperties;
import spring.turbo.module.webmvc.databinding.DataBinderInitializingAdvice;
import spring.turbo.module.webmvc.support.argument.RemoteAddressHandlerMethodArgumentResolver;
import spring.turbo.module.webmvc.support.argument.SharedObjectHandlerMethodArgumentResolver;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringBootWebMvcProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebMvcAutoConfiguration
implements WebMvcConfigurer {
    @Autowired(required=false)
    public void config(@Nullable BeanNameViewResolver beanNameViewResolver) {
        if (beanNameViewResolver != null) {
            beanNameViewResolver.setOrder(Integer.MIN_VALUE);
        }
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> list) {
        list.add(new RemoteAddressHandlerMethodArgumentResolver());
        list.add(new SharedObjectHandlerMethodArgumentResolver());
    }

    @Bean
    @ConditionalOnProperty(prefix="springturbo.webmvc", name={"data-binder-initializing-advice"}, havingValue="true", matchIfMissing=true)
    public DataBinderInitializingAdvice dataBinderInitializingAdvice() {
        return new DataBinderInitializingAdvice();
    }
}

