/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.support.argument;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import spring.turbo.module.webmvc.support.argument.RemoteAddress;
import spring.turbo.module.webmvc.util.RemoteAddressUtils;

public class RemoteAddressHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(RemoteAddress.class) && methodParameter.getParameterType() == String.class;
    }

    @Nullable
    public Object resolveArgument(MethodParameter methodParameter, @Nullable ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, @Nullable WebDataBinderFactory webDataBinderFactory) {
        try {
            return this.doResolveArgument(methodParameter, nativeWebRequest);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public Object doResolveArgument(MethodParameter methodParameter, NativeWebRequest nativeWebRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        String string = null;
        if (httpServletRequest != null && !StringUtils.hasText((String)(string = RemoteAddressUtils.getIpAddress(httpServletRequest)))) {
            string = null;
        }
        if (methodParameter.getParameterType() == String.class) {
            return string;
        }
        if (methodParameter.getParameterType() == Optional.class) {
            return Optional.ofNullable(string);
        }
        return null;
    }
}

