/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.support.argument;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import spring.turbo.module.webmvc.support.argument.SharedObject;
import spring.turbo.util.ThreadSharedObjects;

public class SharedObjectHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(SharedObject.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        SharedObject sharedObject = (SharedObject)methodParameter.getParameterAnnotation(SharedObject.class);
        if (sharedObject == null) {
            return null;
        }
        if (sharedObject.type() != Void.TYPE) {
            return ThreadSharedObjects.get(sharedObject.type());
        }
        if (!"".equals(sharedObject.name())) {
            return ThreadSharedObjects.get((String)sharedObject.name());
        }
        return null;
    }
}

