/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.support.request;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import spring.turbo.module.webmvc.util.version.VersionResolver;

public class VersionedRequestCondition
implements RequestCondition<VersionedRequestCondition> {
    private final VersionResolver versionResolver;
    private final String acceptVersion;
    private final boolean ignoreCase;

    public VersionedRequestCondition(VersionResolver versionResolver, String string, boolean bl) {
        this.versionResolver = versionResolver;
        this.acceptVersion = string.trim();
        this.ignoreCase = bl;
    }

    public VersionedRequestCondition combine(VersionedRequestCondition versionedRequestCondition) {
        return this;
    }

    public int compareTo(VersionedRequestCondition versionedRequestCondition, HttpServletRequest httpServletRequest) {
        return 0;
    }

    @Nullable
    public VersionedRequestCondition getMatchingCondition(HttpServletRequest httpServletRequest) {
        String string = this.versionResolver.resolve(httpServletRequest);
        if (string == null) {
            return null;
        }
        if (this.ignoreCase) {
            return string.equalsIgnoreCase(this.acceptVersion) ? this : null;
        }
        return string.equals(this.acceptVersion) ? this : null;
    }
}

