/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.support.request;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import spring.turbo.module.webmvc.support.request.Versioned;
import spring.turbo.module.webmvc.support.request.VersionedRequestCondition;
import spring.turbo.module.webmvc.util.version.CompositeVersionResolver;
import spring.turbo.module.webmvc.util.version.VersionResolver;

public class VersionedRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private final VersionResolver versionResolver;

    public VersionedRequestMappingHandlerMapping() {
        this(null);
    }

    public VersionedRequestMappingHandlerMapping(@Nullable VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNullElseGet(versionResolver, CompositeVersionResolver::getDefault);
    }

    @Nullable
    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        Versioned versioned = (Versioned)AnnotationUtils.findAnnotation((Method)method, Versioned.class);
        if (versioned == null) {
            return null;
        }
        AnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)versioned, (boolean)false, (boolean)false);
        return new VersionedRequestCondition(this.versionResolver, annotationAttributes.getString("value"), annotationAttributes.getBoolean("ignoreCase"));
    }
}

