/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.support.response;

import java.awt.image.BufferedImage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import spring.turbo.util.io.ImageUtils;

public final class ImageResponseEntity
extends ResponseEntity<byte[]> {
    private ImageResponseEntity(byte[] byArray, MultiValueMap<String, String> multiValueMap, HttpStatus httpStatus) {
        super((Object)byArray, multiValueMap, (HttpStatusCode)httpStatus);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpStatus status = HttpStatus.OK;
        private String format = "png";
        @Nullable
        private BufferedImage image;

        private Builder() {
        }

        public Builder status(HttpStatus httpStatus) {
            this.status = httpStatus;
            return this;
        }

        public Builder image(BufferedImage bufferedImage) {
            this.image = bufferedImage;
            return this;
        }

        public Builder format(String string) {
            this.format = string;
            return this;
        }

        public ImageResponseEntity build() {
            byte[] byArray = ImageUtils.toByteArray((BufferedImage)this.image, (String)this.format);
            int n = byArray.length;
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add((Object)"Content-Type", (Object)("image/" + this.format));
            httpHeaders.add((Object)"Content-Length", (Object)String.valueOf(n));
            return new ImageResponseEntity(byArray, (MultiValueMap<String, String>)httpHeaders, this.status);
        }
    }
}

