/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.NativeWebRequest;

public final class RemoteAddressUtils {
    private RemoteAddressUtils() {
    }

    @Nullable
    public static String getIpAddress(HttpServletRequest httpServletRequest) {
        String string;
        block7: {
            block6: {
                string = httpServletRequest.getHeader("X-Forwarded-For");
                if (string != null && string.length() != 0 && !"unknown".equalsIgnoreCase(string)) break block6;
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("Proxy-Client-IP");
                }
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
                }
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("HTTP_CLIENT_IP");
                }
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (string != null && string.length() != 0 && !"unknown".equalsIgnoreCase(string)) break block7;
                string = httpServletRequest.getRemoteAddr();
                break block7;
            }
            if (string.length() > 15) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    if ("unknown".equalsIgnoreCase(string2)) continue;
                    string = string2;
                    break;
                }
            }
        }
        return string;
    }

    public static String getRequiredIpAddress(HttpServletRequest httpServletRequest) {
        String string = RemoteAddressUtils.getIpAddress(httpServletRequest);
        return Objects.requireNonNull(string);
    }

    @Nullable
    public static String getIpAddress(NativeWebRequest nativeWebRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        return RemoteAddressUtils.getIpAddress(httpServletRequest);
    }

    public static String getRequiredIpAddress(NativeWebRequest nativeWebRequest) {
        String string = RemoteAddressUtils.getIpAddress(nativeWebRequest);
        return Objects.requireNonNull(string);
    }
}

