/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class ServletUtils {
    private ServletUtils() {
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        try {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            return servletRequestAttributes.getRequest();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static HttpServletRequest getRequiredRequest() {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        return Objects.requireNonNull(httpServletRequest);
    }

    public static HttpServletRequest getUnwrappedRequest() {
        HttpServletRequest httpServletRequest = ServletUtils.getRequiredRequest();
        while (httpServletRequest instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest;
            httpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        return httpServletRequest;
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        try {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            return servletRequestAttributes.getResponse();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static HttpServletResponse getRequiredResponse() {
        HttpServletResponse httpServletResponse = ServletUtils.getResponse();
        return Objects.requireNonNull(httpServletResponse);
    }

    public static HttpServletResponse getUnwrappedResponse() {
        HttpServletResponse httpServletResponse = ServletUtils.getRequiredResponse();
        while (httpServletResponse instanceof HttpServletResponseWrapper) {
            HttpServletResponseWrapper httpServletResponseWrapper = (HttpServletResponseWrapper)httpServletResponse;
            httpServletResponse = (HttpServletResponse)httpServletResponseWrapper.getResponse();
        }
        return httpServletResponse;
    }

    public static HttpSession getSession() {
        return ServletUtils.getSession(true);
    }

    public static HttpSession getSession(boolean bl) {
        return ServletUtils.getRequiredRequest().getSession(bl);
    }

    public static String getSessionId() {
        return ServletUtils.getSession().getId();
    }

    public static ServletContext getServletContext() {
        return ServletUtils.getRequiredRequest().getServletContext();
    }
}

