/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.autoconfiguration;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import spring.turbo.module.webmvc.support.argument.RemoteAddressHandlerMethodArgumentResolver;
import spring.turbo.module.webmvc.support.locale.SystemDefaultLocaleResolver;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebMvcAutoConfiguration
implements WebMvcConfigurer {
    @Autowired(required=false)
    public void config(@Nullable BeanNameViewResolver beanNameViewResolver) {
        if (beanNameViewResolver != null) {
            beanNameViewResolver.setOrder(Integer.MIN_VALUE);
        }
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> list) {
        list.add(new RemoteAddressHandlerMethodArgumentResolver());
    }

    @Bean
    @ConditionalOnMissingBean
    public LocaleResolver localeResolver() {
        return SystemDefaultLocaleResolver.getInstance();
    }
}

