/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.util.version;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.OrderComparator;
import org.springframework.lang.Nullable;
import spring.turbo.module.webmvc.util.version.HeaderVersionResolver;
import spring.turbo.module.webmvc.util.version.NullVersionResolver;
import spring.turbo.module.webmvc.util.version.QueryVersionResolver;
import spring.turbo.module.webmvc.util.version.ServletPathVersionResolver;
import spring.turbo.module.webmvc.util.version.VersionResolver;
import spring.turbo.util.collection.CollectionUtils;

public class CompositeVersionResolver
implements VersionResolver,
InitializingBean {
    private final List<VersionResolver> resolvers = new ArrayList<VersionResolver>();

    public CompositeVersionResolver(VersionResolver ... versionResolverArray) {
        CollectionUtils.nullSafeAddAll(this.resolvers, (Object[])versionResolverArray);
        OrderComparator.sort(this.resolvers);
        this.afterPropertiesSet();
    }

    public CompositeVersionResolver(Collection<VersionResolver> collection) {
        CollectionUtils.nullSafeAddAll(this.resolvers, collection);
        OrderComparator.sort(this.resolvers);
        this.afterPropertiesSet();
    }

    public static CompositeVersionResolver getDefault() {
        return new CompositeVersionResolver(new ServletPathVersionResolver(), new HeaderVersionResolver(), new QueryVersionResolver());
    }

    public void afterPropertiesSet() {
        if (this.resolvers.isEmpty()) {
            this.resolvers.add(NullVersionResolver.getInstance());
        }
    }

    @Override
    @Nullable
    public String resolve(HttpServletRequest httpServletRequest) {
        for (VersionResolver versionResolver : this.resolvers) {
            try {
                String string = versionResolver.resolve(httpServletRequest);
                if (string == null) continue;
                return string;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

