/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.util.version;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import spring.turbo.module.webmvc.util.version.VersionResolver;
import spring.turbo.util.Asserts;
import spring.turbo.util.StringUtils;

public class HeaderVersionResolver
implements VersionResolver {
    private static final String DEFAULT_HEADER_NAME = "X-Api-Version";
    private final String headerName;

    public HeaderVersionResolver() {
        this(DEFAULT_HEADER_NAME);
    }

    public HeaderVersionResolver(String string) {
        Asserts.hasText((String)string);
        this.headerName = string;
    }

    @Override
    @Nullable
    public String resolve(HttpServletRequest httpServletRequest) {
        try {
            String string = httpServletRequest.getHeader(this.headerName);
            return StringUtils.isNotBlank((String)string) ? string : null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public int getOrder() {
        return -2147483548;
    }
}

